<?php
/**
 * SportsHub Recaps
 *
 * @package SHRECAPS
 * @author  IT
 * @version 1.1.0
 *
 * @wordpress-plugin
 * Plugin Name: SportsHub Recaps
 * Plugin URI:  https://www.sportshub.com
 * Description: SportsHub Network Recaps Importer
 * Version:     1.1.0
 * Author:      IT
 * Author URI:  https://www.sportshub.com
 * Text Domain: sportshub-recaps
 * Domain Path: /languages
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/**
 * HELPER COMMENT START
 *
 * This file contains the main information about the plugin.
 * It is used to register all components necessary to run the plugin.
 *
 * The comment above contains all information about the plugin
 * that are used by WordPress to differenciate the plugin and register it properly.
 * It also contains further PHPDocs parameter for a better documentation
 *
 * The function SHRECAPS() is the main function that you will be able to
 * use throughout your plugin to extend the logic. Further information
 * about that is available within the sub classes.
 *
 * HELPER COMMENT END
 */

// Plugin name
define('SHRECAPS_NAME', 'SportsHub Recaps');
define('SHRECAPS_NAME_SLUG', 'sportshub-recaps');

// Plugin version
define('SHRECAPS_VERSION', '1.1.0');

// REDIS
define('REDIS_GROUP_SHRECAPS', 'sh_recaps');

if (!defined('SHRECAPS_REDIS_TIMEOUT')) {
    define('SHRECAPS_REDIS_TIMEOUT', 3600);
}

// UPLOAD DIR
$plugin_upload_dir = wp_upload_dir()['basedir'] . '/' . str_replace(' ', '_', SHRECAPS_NAME);
define('SHRECAPS_PLUGIN_LOG_DIR', $plugin_upload_dir);

// Plugin Root File
define('SHRECAPS_PLUGIN_FILE', __FILE__);

// Plugin base
define('SHRECAPS_PLUGIN_BASE', plugin_basename(SHRECAPS_PLUGIN_FILE));

// Plugin Folder Path
define('SHRECAPS_PLUGIN_DIR', plugin_dir_path(SHRECAPS_PLUGIN_FILE));

// Plugin Folder URL
define('SHRECAPS_PLUGIN_URL', plugin_dir_url(SHRECAPS_PLUGIN_FILE));

define('BLOCK_SH_RECAP', 'sh-recap');
define('BLOCK_SH_RECAP_LINKS', 'sh-recap-links');
define('BLOCK_SH_RECAP_ODDS', 'sh-recap-odds');
define('BLOCK_SH_RECAP_PICKS_RECAPS', 'sh-recap-picks-recaps');
define('BLOCK_SH_RECAP_TOP_HANDICAPPER', 'sh-recap-top-handicapper');
define('BLOCK_SH_RECAP_PICKS', 'sh-recap-picks');

/**
 * Load the main class for the core functionality
 */
require_once SHRECAPS_PLUGIN_DIR . 'core/class-sportshub-recaps.php';
require_once SHRECAPS_PLUGIN_DIR . 'blocks/sh-blocks-base.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  IT
 * @since   1.0.0
 * @return  object|Sportshub_Recaps
 */
function SHRECAPS() {
    $shr = Sportshub_Recaps::instance();

    return $shr;
}

$shr = SHRECAPS();
update_option('shr_slug', $shr->get_slug(false));
