<?php
    global $shr;
    $shr = (!empty($shr)) ? $shr : Sportshub_Recaps::instance();

    $block_styles = [];
    $block_classes = [BLOCK_SH_RECAP];
    $block_game = $shr->settings->get_block(BLOCK_SH_RECAP);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $shr->helpers->get_blocks_spaces(get_fields());

    $post = get_post();
    $fields = $block_game->get_block_fields($post, $shr);
    $type = (isset($fields['type']) && !empty($fields['type'])) ? $fields['type'] : null;
    $example = (isset($fields['example']) && !empty($fields['example'])) ? $fields['example'] : null;
    $invalid_fields = (isset($fields['invalid_fields']) && !empty($fields['invalid_fields'])) ? $fields['invalid_fields'] : null;
?>

<?php if ($type != 'example' && $type != ''): ?>
    <?php
        $params = ['type_game' => $type, 'data' => $example, 'invalid_fields' => $invalid_fields];
        $block_game->getLogDebug($params);
    ?>
<?php else: ?>
    <?php if (empty(get_option('shr_source')) || get_option('shr_source') == 'members'): ?>
        <div class="shr-blocks">
            <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
                <div class="content">
                    <div class="game">
                        <div class="game-header">
                            <span class="teams">
                                <?php if ($type == 'example'): ?>
                                    <span class="team">EXAMPLE</span>
                                <?php endif; ?>
                                <?php $shr_home_team = (is_array($fields['shr_home_team']) && isset($fields['shr_home_team'][0])) ? $fields['shr_home_team'][0] : $fields['shr_home_team']; ?>
                                <?php $shr_visitor_team = (is_array($fields['shr_visitor_team']) && isset($fields['shr_visitor_team'][0])) ? $fields['shr_visitor_team'][0] : $fields['shr_visitor_team']; ?>
                                <span class="team"><?php echo $shr_home_team; ?></span>
                                <span class="vs">vs</span>
                                <span class="team"><?php echo $shr_visitor_team; ?></span>
                            </span>
                            <span class="date">
                                <span class="sport"><?php echo $fields['title']; ?></span>
                                <span class="separator"> <?php echo (!empty($fields['title'])) ? '•' : ''; ?></span>
                                <span class="time"> <?php echo date('D, M j, H:i a.', strtotime($fields['shr_game_date'])); ?></span>
                            </span>
                        </div>
                        <div class="game-body">
                            <div class="content-body">
                                <div class="content-teams">
                                    <div class="team-home">
                                        <div class="team">
                                            <div class="team-name">
                                                <span class="name">
                                                    <?php echo $shr_home_team; ?>
                                                </span>
                                                <div class="stats">
                                                    <span class="pill <?php echo ($fields['shr_home_money_odds'] < 0) ? 'success' : 'info'; ?>">ML: <?php echo $fields['shr_home_money_odds']; ?></span>
                                                </div>
                                            </div>
                                            <div class="team-logo">
                                                <?php if (isset($fields['shr_home_local_url']) && !empty($fields['shr_home_local_url'])): ?>
                                                    <?php
                                                        $team_home_image = $shr->helpers->getNameFile($fields['shr_home_local_url']);
                                                        $team_home_alt = (isset($team_home_image['alt']) && !empty($team_home_image['alt'])) ? $team_home_image['alt'] : '';
                                                    ?>
                                                    <img src="<?php echo $fields['shr_home_local_url']; ?>" alt="<?php echo $team_home_alt; ?>">
                                                <?php endif; ?>
                                            </div>
                                            <div class="team-score">
                                                <span class="score"><?php echo $fields['shr_home_score']; ?></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="team-separator"></div>
                                    <div class="team-visitor">
                                        <div class="team">
                                            <div class="team-score">
                                                <span class="score"><?php echo $fields['shr_visitor_score']; ?></span>
                                            </div>
                                            <div class="team-logo">
                                                <?php if (isset($fields['shr_visitor_local_url']) && !empty($fields['shr_visitor_local_url'])): ?>
                                                    <?php
                                                        $team_visitor_image = $shr->helpers->getNameFile($fields['shr_visitor_local_url']);
                                                        $team_visitor_alt = (isset($team_visitor_image['alt']) && !empty($team_visitor_image['alt'])) ? $team_visitor_image['alt'] : '';
                                                    ?>
                                                    <img src="<?php echo $fields['shr_visitor_local_url']; ?>" alt="<?php echo $team_visitor_alt; ?>">
                                                <?php endif; ?>
                                            </div>
                                            <div class="team-name">
                                                <span class="name"><?php echo $shr_visitor_team; ?></span>
                                                <div class="stats">
                                                    <span class="pill <?php echo ($fields['shr_away_money_odds'] < 0) ? 'success' : 'info'; ?>">ML: <?php echo $fields['shr_away_money_odds']; ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>
