<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shr_Blocks_Recap_Odds extends Sh_Blocks_Base
{
    protected $block_name = BLOCK_SH_RECAP_ODDS;
    private $block_folder_name = BLOCK_SH_RECAP_ODDS;
    private $block_title = 'SH Recap Odds';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['shr', 'custom', 'game', 'odd'];
    private $block_mode = 'preview';
    private $block_category = SHRECAPS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $shr_helpers = new Sportshub_Recaps_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => SHRECAPS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $shr_helpers->webpack('sh_recap_odds.css'),
                'enqueue_assets' => function() {
                    wp_enqueue_style('shrecaps_styles');
                    wp_enqueue_script('shrecaps_scripts');
                },
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function get_block_fields($post, $shr) {
        $example_fields = [
            'shr_game_top_handicapper_id' => '71',
            'shr_game_top_handicapper_name' => 'Totals Guru',
            'shr_game_top_handicapper_local_image' => SHRECAPS_PLUGIN_URL.'blocks/sh-recap-top-handicapper/assets/img/capper.png',
            'shr_game_top_handicapper_description' => "<p>Picks can be found on BestBettor, part of SportsCapping Group.</p><p>The Totals Guru believes there is an unmatched value in over/under wagers.&nbsp; That is why he doesn't play any sides, just totals!</p>",
            'shr_game_results_rank' => '1',
            'shr_sport_name' => 'Basketball',
            'shr_game_results_yesterday' => '100',
            'shr_game_results_lastthreedays' => '90',
            'shr_game_results_lastsevendays' => '-140',
            'shr_game_results_lastthirtydays' => '390',
        ];

        $fields_validate = [];
        
        if ($post->post_type == 'gp_elements') {
            return array_merge($example_fields, [
                'type' => 'example',
            ]);
        }

        $validate = true;
        $custom_fields = [];

        foreach ($example_fields as $key => $value) {
            $custom_fields[$key] = get_field($key, $post->ID);
        }

        $invalid_fields = [];

        foreach ($example_fields as $key => $value) {
            if (!isset($custom_fields[$key]) || empty($custom_fields[$key])) {
                if (!isset($fields_validate[$key]) || (isset($fields_validate[$key]) && $fields_validate[$key] != 'nullable')) {
                    $validate = false;
                    $invalid_fields[$key] = $custom_fields[$key];
                }
            }
        }

        if (!$validate) {
            return array_merge($example_fields, [
                'type' => 'Invalid field validation',
                'example' => $example_fields,
                'invalid_fields' => $invalid_fields,
            ]);
        }

        return array_merge($custom_fields, ['type' => '']);
    }

    public function getOdds($post_id)
    {
        return [
            'shr_game_id_odds' => (!empty(get_field('shr_game_id_odds', $post_id))) ? get_field('shr_game_id_odds', $post_id) : '',
            'shr_external_id_odds' => (!empty(get_field('shr_external_id_odds', $post_id))) ? get_field('shr_external_id_odds', $post_id) : '',
            'shr_sportsbook_odds' => (!empty(get_field('shr_sportsbook_odds', $post_id))) ? get_field('shr_sportsbook_odds', $post_id) : '',
            'shr_date_odds' => (!empty(get_field('shr_date_odds', $post_id))) ? get_field('shr_date_odds', $post_id) : null,
            'shr_home_handicap_spread_odds' => (!empty(get_field('shr_home_handicap_spread_odds', $post_id))) ? get_field('shr_home_handicap_spread_odds', $post_id) : '-',
            'shr_away_handicap_spread_odds' => (!empty(get_field('shr_away_handicap_spread_odds', $post_id))) ? get_field('shr_away_handicap_spread_odds', $post_id) : '-',
            'shr_home_spread_odds' => (!empty(get_field('shr_home_spread_odds', $post_id))) ? get_field('shr_home_spread_odds', $post_id) : '-',
            'shr_away_spread_odds' => (!empty(get_field('shr_away_spread_odds', $post_id))) ? get_field('shr_away_spread_odds', $post_id) : '-',
            'shr_home_money_odds' => (!empty(get_field('shr_home_money_odds', $post_id))) ? get_field('shr_home_money_odds', $post_id) : '-',
            'shr_away_money_odds' => (!empty(get_field('shr_away_money_odds', $post_id))) ? get_field('shr_away_money_odds', $post_id) : '-',
            'shr_home_handicap_overunder_odds' => (!empty(get_field('shr_home_handicap_overunder_odds', $post_id))) ? get_field('shr_home_handicap_overunder_odds', $post_id) : '-',
            'shr_away_handicap_overunder_odds' => (!empty(get_field('shr_away_handicap_overunder_odds', $post_id))) ? get_field('shr_away_handicap_overunder_odds', $post_id) : '-',
            'shr_home_overunder_odds' => (!empty(get_field('shr_home_overunder_odds', $post_id))) ? get_field('shr_home_overunder_odds', $post_id) : '-',
            'shr_away_overunder_odds' => (!empty(get_field('shr_away_overunder_odds', $post_id))) ? get_field('shr_away_overunder_odds', $post_id) : '-',
        ];
    }

    public function getStyle($value)
    {
        if (substr($value, 0, 1) == '-') {
            return 'bg-green';
        }

        if (substr($value, 0, 1) == '+') {
            return 'bg-grey';
        }

        return '';
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-shr-recaps-odds-bg-grey','slug' => 'color-shr-recaps-odds-bg-grey','color' => '#f5f8fd'],
            ['name' => 'color-shr-recaps-odds-bg-green','slug' => 'color-shr-recaps-odds-bg-green','color' => '#d3f3c2'],
            ['name' => 'color-shr-recaps-odds-date','slug' => 'color-shr-recaps-odds-date','color' => '#acaaaa'],
            ['name' => 'color-shr-recaps-odds-labels','slug' => 'color-shr-recaps-odds-labels','color' => '#acaaaa'],
            ['name' => 'color-shr-recaps-odds-team-name-bg','slug' => 'color-shr-recaps-odds-team-name-bg','color' => '#f7f8f9'],
            ['name' => 'color-shr-recaps-odds-inner-shadow','slug' => 'color-shr-recaps-odds-inner-shadow','color' => '#d6d6d6'],
            ['name' => 'color-shr-recaps-odds-inner-bg','slug' => 'color-shr-recaps-odds-inner-bg','color' => '#ffffff'],
            ['name' => 'color-shr-recaps-odds-title-color','slug' => 'color-shr-recaps-odds-title-color','color' => '#111111'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.sh-recap-odds .odd-content .odd-body .header-labels',
                'fontWeight' => '600',
                'fontSize' => '0.85rem',
                'LineHeight' => '2rem',
            ],
            [
                'customSelector' => '.sh-recap-odds .odd-content .odd-body .odd-teams',
                'fontWeight' => '700',
                'fontSize' => '1rem',
                'LineHeight' => '2rem',
            ],
            [
                'customSelector' => '.sh-recap-odds .odd-header .odd-title',
                'fontWeight' => '700',
                'fontSize' => '2rem',
                'fontSizeTablet' => '1.6rem',
                'fontSizeMobile' => '1.4rem',
            ],
            [
                'customSelector' => '.sh-recap-odds .odd-header .header-date',
                'fontSize' => '0.9rem',
            ],
        ];
    }
}

$sh_recap_odds_class = new Shr_Blocks_Recap_Odds();
$sh_recap_odds_class->init();

return $sh_recap_odds_class;
