<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shr_Blocks_Recap_Links extends Sh_Blocks_Base
{
    protected $block_name = BLOCK_SH_RECAP_LINKS;
    private $block_folder_name = BLOCK_SH_RECAP_LINKS;
    private $block_title = 'SH Recap Links';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['shr', 'custom', 'game', 'link'];
    private $block_mode = 'preview';
    private $block_category = SHRECAPS_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $shr_helpers = new Sportshub_Recaps_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => SHRECAPS_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $shr_helpers->webpack('sh_recap_links.css'),
                'enqueue_assets' => function() {
                    wp_enqueue_style('shrecaps_styles');
                    wp_enqueue_script('shrecaps_scripts');
                },
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-shr-recaps-links-primary','slug' => 'color-shr-recaps-links-primary','color' => '#0160ac'],
            ['name' => 'color-shr-recaps-links-gray','slug' => 'color-shr-recaps-links-gray','color' => '#dedede'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.sh-recap-links .links-body .default .link, .links-body .default .link',
                'fontSize' => '1rem',
                'fontWeight' => '600',
            ],
            [
                'customSelector' => '.sh-recap-links .links-body .primary, .links-body .primary',
                'fontSize' => '1.2rem',
                'fontWeight' => '600',
            ],
        ];
    }
}

$sh_recap_links_class = new Shr_Blocks_Recap_Links();
$sh_recap_links_class->init();

return $sh_recap_links_class;
