<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/**
 * Class Sportshub_Games_Helpers
 *
 * This class contains repetitive functions that
 * are used globally within the plugin.
 *
 * @package     SHGAMES
 * @subpackage  Classes/Sportshub_Games_Helpers
 * @author      IT
 * @since       1.0.0
 */
class Sportshub_Games_Helpers {
    private $redis_cache;
    private $redis_cache_group;

    function __construct() {
        $this->redis_cache = $this->initRedis();
        $this->setRedisGroup();
    }

    public function initRedis() {
        global $wp_object_cache;

        if (isset($wp_object_cache->redis) && $wp_object_cache->redis instanceof \Redis) {
            return true;
        }

        return false;
    }

    public function setRedisGroup($group = '') {
        $this->redis_cache_group = $group;
    }

    public function setRedis($key, $data, $expire = 0) {
        wp_cache_set($key, $data, $this->redis_cache_group, $expire);

        return true;
    }

    public function getRedis($key) {
        return wp_cache_get($key, $this->redis_cache_group);
    }

    public function deleteRedis($key) {
        wp_cache_delete($key, $this->redis_cache_group);

        return true;
    }

    public function getRedisKeySportsLeagues() {
        return 'shgames_sports_leagues_queue';
    }

    public function getRedisKeySports() {
        return 'shgames_sports_queue';
    }

    public function getSporstLeaguesOptions($is_sub_title = false) {
        if ($this->initRedis()) {
            $this->setRedisGroup(REDIS_GROUP_SHGAMES);

            if (!$is_sub_title) {
                $key = $this->getRedisKeySports();
            } else {
                $key = $this->getRedisKeySportsLeagues();
            }

            $data_sports_leagues = $this->getRedis($key);
    
            if (!empty($data_sports_leagues)) {
                return unserialize($data_sports_leagues);
            }
        }

        $sports_leagues_fields = get_field('shgame_sports_and_leagues', 'option');

        if (is_array($sports_leagues_fields) && count($sports_leagues_fields) > 0) {
            for ($i = 0; $i <= 1 ; $i++) {
                if ($i == 0) {
                    $is_sub_title = false;
                    $key = $this->getRedisKeySports();
                } else {
                    $is_sub_title = true;
                    $key = $this->getRedisKeySportsLeagues();
                }
    
                $sports_leagues = [];

                foreach ($sports_leagues_fields as $sport_league) {
                    if (is_array($sport_league['shg_leagues']) && count($sport_league['shg_leagues']) > 0 && $is_sub_title) {
                        $leagues = [];
                        $leagues[$sport_league['shg_sport_id']] = $sport_league['shg_sport_title'] .' - '. __('ANY CATEGORY');
    
                        foreach ($sport_league['shg_leagues'] as $sub_title) {
                            $leagues[$sport_league['shg_sport_id'].'-'.$sub_title['shg_league_id']] = $sport_league['shg_sport_title'] .' | '. $sub_title['shg_league_title'];
                        }
                    } else {
                        $leagues = $sport_league['shg_sport_title'];
                    }
    
                    if (is_array($leagues)) {
                        $sports_leagues[$sport_league['shg_sport_title']] = $leagues;
                    } else {
                        $sports_leagues[$sport_league['shg_sport_id']] = $leagues;
                    }
                }

                if ($this->initRedis() && is_array($sports_leagues) && count($sports_leagues) > 0) {
                    $this->setRedis($key, serialize($sports_leagues), REDIS_TIMEOUT);
                }
            }
        }
    }

    public function getNameFile($image_url, $is_logo = true)
    {
        $is_image = false;
        $file_name = '';
        $image_alt = '';
        $file_extension = '';
        $extensions_images = ['png', 'jpg', 'jpeg', 'gif', 'webp'];

        try {
            $parts = explode('/', $image_url);
            $image_name = $parts[count($parts) - 1];
            $image_name_parts = explode('.', $image_name);
            $file_extension = strtolower($image_name_parts[count($image_name_parts) - 1]);
            unset($image_name_parts[count($image_name_parts) - 1]);
            $file_name = implode('.', $image_name_parts);
            $title_image = $file_name;

            $image_alt = str_replace('_', ' ', $file_name);
            $image_alt = str_replace('-', ' ', $image_alt);
            $image_alt = str_replace('.', ' ', $image_alt);
            $image_alt = ucwords(strtolower($image_alt));

            $is_image = (in_array($file_extension, $extensions_images)) ? true : false;

            if ($is_logo) $image_alt .= ' Logo';
        } catch (\Exception $exception) {
            error_log(print_r([
                'is_logo' => $is_logo,
                'image_url' => $image_url,
                'exception' => $exception->getMessage(),
            ], true));
        }

        return [
            'is_image' => $is_image,
            'name' => $image_name,
            'title' => sanitize_title($title_image),
            'alt' => $image_alt,
            'extension' => $file_extension,
            'image_url' => $image_url,
        ];
    }
}
