<?php 
    global $shg;
    $shg = (!empty($shg)) ? $shg : Sportshub_Games::instance();

    $block_styles = [];
    $block_classes = [BLOCK_SHG_GAME_TOP_HANDICAPPER];
    $block_game_handicapper = $shg->settings->get_block(BLOCK_SHG_GAME_TOP_HANDICAPPER);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $shg->helpers->get_blocks_spaces(get_fields());

    $post = get_post();
    $fields = $block_game_handicapper->get_block_fields($post, $shg);
    $type = (isset($fields['type']) && !empty($fields['type'])) ? $fields['type'] : null;
    $example = (isset($fields['example']) && !empty($fields['example'])) ? $fields['example'] : null;
    $invalid_fields = (isset($fields['invalid_fields']) && !empty($fields['invalid_fields'])) ? $fields['invalid_fields'] : null;

    $block_top_handicapper = 'top-handicapper';
    $block_top_handicapper_picks = 'picks';
    $block_top_handicapper_odds = 'odds';
    $is_config = $shg->helpers->isConfigBlock($block_top_handicapper);
    $picks = (is_array(get_field('shg_picks', $post->ID)) && count(get_field('shg_picks', $post->ID)) > 0) ? get_field('shg_picks', $post->ID) : [];

    $types = $shg->helpers->getContentTypeBlock(['top-handicapper', 'picks', 'odds']);
    $odd_data = $block_game_handicapper->getOdds($post->ID);
?>

<?php if ($is_config): ?>
    <?php if ($type != 'example' && $type != ''): ?>
        <?php
            $params = ['type_game' => $type, 'data' => $example, 'invalid_fields' => $invalid_fields];
            $block_game_handicapper->get_log_debug($params);
        ?>
    <?php else: ?>
        <?php if (empty(get_option('shg_source')) || get_option('shg_source') == 'members'): ?>
            <div class="shg-blocks">
                <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
                    <div class="container content grid-container">
                        <div class="inner-content">
                            <div class="top-header">
                                <?php if ($type == 'example'): ?>
                                    <span id="block-game-links-top-handicapper" class="top-title">EXAMPLE Top Handicapper</span>
                                <?php else: ?>
                                    <span id="block-game-links-top-handicapper" class="top-title"><?php echo $block_game_handicapper->getTitle($block_top_handicapper, $types, $fields); ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="top-content">
                                <div class="top-capper">
                                    <img src="<?php echo $fields['shg_game_top_handicapper_local_image']; ?>" alt="">
                                </div>
                                <div class="top-body">
                                    <div class="body-header">
                                        <div class="header">
                                            <div class="body-header-capper">
                                                <span class="name"><?php echo $fields['shg_game_top_handicapper_name']; ?></span>
                                                <span class="separator">|</span>
                                                <span class="cat">Handicapper</span>
                                            </div>
                                        </div>
                                        <div class="body-description"><?php echo $fields['shg_game_top_handicapper_description']; ?></div>
                                    </div>
                                    <div class="games">
                                        <div class="game">
                                            <div class="game-title">
                                                #<?php echo $fields['shg_game_results_rank']; ?>
                                                <?php echo $fields['shg_game_results_sport_name']; ?>
                                            </div>
                                            <div class="game-body">
                                                <div class="list-games">
                                                    <div class="list-game">
                                                        <div class="time">Yesterday</div>
                                                        <div class="amount"><?php echo $fields['shg_game_results_yesterday']; ?></div>
                                                    </div>
                                                    <div class="list-game">
                                                        <div class="time">Last 7 days</div>
                                                        <div class="amount"><?php echo $fields['shg_game_results_lastthreedays']; ?></div>
                                                    </div>
                                                    <div class="list-game">
                                                        <div class="time">Last 3 days</div>
                                                        <div class="amount"><?php echo $fields['shg_game_results_lastsevendays']; ?></div>
                                                    </div>
                                                    <div class="list-game">
                                                        <div class="time">Last 30 days</div>
                                                        <div class="amount"><?php echo $fields['shg_game_results_lastthirtydays']; ?></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="game-footer"></div>
                                        </div>
                                        <div class="game">
                                            <div id="block-game-links-odds" class="game-title"><?php echo $block_game_handicapper->getTitle($block_top_handicapper_odds, $types, $fields); ?></div>
                                            <div class="game-body">
                                                <div class="content-odds">
                                                    <div class="header">
                                                        <div class="header-date"></div>
                                                        <div class="header-labels">
                                                            <div class="spread">apread</div>
                                                            <div class="moneyline">moneyline</div>
                                                            <div class="over-under">over/under</div>
                                                        </div>
                                                    </div>
                                                    <div class="teams">
                                                        <div class="team home-team">
                                                            <div class="team-name"><?php echo $block_game_handicapper->getTeamName('home', $post->ID); ?></div>
                                                            <div class="team-stats">
                                                                <div class="spread"><?php echo $odd_data['shg_home_handicap_spread_odds'].' '.$odd_data['shg_home_spread_odds']; ?></div>
                                                                <div class="moneyline"><?php echo $odd_data['shg_home_money_odds']; ?></div>
                                                                <div class="over-under"><?php echo $odd_data['shg_home_handicap_overunder_odds'].' '.$odd_data['shg_home_overunder_odds']; ?></div>
                                                            </div>
                                                        </div>
                                                        <div class="team visitor-team">
                                                            <div class="team-name"><?php echo $block_game_handicapper->getTeamName('visitor', $post->ID); ?></div>
                                                            <div class="team-stats">
                                                                <div class="spread"><?php echo $odd_data['shg_away_handicap_spread_odds'].' '.$odd_data['shg_away_spread_odds']; ?></div>
                                                                <div class="moneyline"><?php echo $odd_data['shg_away_money_odds']; ?></div>
                                                                <div class="over-under"><?php echo $odd_data['shg_away_handicap_overunder_odds'].' '.$odd_data['shg_away_overunder_odds']; ?></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="game-footer"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php $is_config_picks = $shg->helpers->isConfigBlock($block_top_handicapper_picks); ?>
                            <?php if ($is_config_picks && is_array($picks) && count($picks) > 0): ?>
                                <div class="top-header">
                                    <?php if ($type == 'example'): ?>
                                        <span id="block-game-links-picks" class="top-title title-picks">EXAMPLE Sports Picks</span>
                                    <?php else: ?>
                                        <span id="block-game-links-picks" class="top-title title-picks"><?php echo $block_game_handicapper->getTitle($block_top_handicapper_picks, $types, $fields); ?></span>
                                    <?php endif; ?>
                                </div>
                                <div class="picks">
                                    <?php if (is_array($picks) && count($picks) > 0): ?>
                                        <?php foreach ($picks as $pick): ?>
                                            <div class="pick">
                                                <div class="pick-header">
                                                    <div class="content">
                                                        <div class="sport"><span></span></div>
                                                        <div class="date-time">
                                                            <span>
                                                                <?php
                                                                    try {
                                                                        $d = DateTime::createFromFormat('Y-m-d H:i:s', $pick['shg_pick_date']);
                                                                        $date_status = $d && $d->format('Y-m-d H:i:s') == $pick['shg_pick_date'];

                                                                        if ($date_status) {
                                                                            echo $d->format('Y-m-d H:i');
                                                                        }
                                                                    } catch (\Exception $exception) {
                                                                        //
                                                                    }
                                                                ?>
                                                            </span>
                                                        </div>
                                                        <div class="status"><span></span></div>
                                                    </div>
                                                </div>
                                                <div class="pick-body">
                                                    <div class="teams">
                                                        <div class="team team-a">
                                                            <div class="team-logo">
                                                                <img src="<?php echo $pick['shg_pick_visitor_image_local']; ?>" alt="">
                                                            </div>
                                                            <div class="team-name"><span><?php echo $pick['shg_pick_visitor_name']; ?></span></div>
                                                        </div>
                                                        <div class="team team-vs">
                                                            <div class="vs-logo"><span>vs</span></div>
                                                            <?php
                                                                $url = (!empty($pick['shg_pick_game_url'])) ? $pick['shg_pick_game_url'] : '#';
                                                                $target = '_blank';
                                                            ?>
                                                        </div>
                                                        <div class="team team-b">
                                                            <div class="team-logo">
                                                                <img src="<?php echo $pick['shg_pick_home_image_local']; ?>" alt="">
                                                            </div>
                                                            <div class="team-name"><span><?php echo $pick['shg_pick_home_name']; ?></span></div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="pick-link">
                                                    <a href="<?php echo $url; ?>" target="<?php echo $target; ?>" rel="noopener nofollow">
                                                        <div class="link">
                                                            <span>Get this pick</span>
                                                        </div>
                                                    </a>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>
<?php endif; ?>
