<?php 
    global $shg;
    $shg = (!empty($shg)) ? $shg : Sportshub_Games::instance();

    $block_styles = [];
    $block_classes = [BLOCK_SHG_GAME_LINKS];
    $block_game = $shg->settings->get_block(BLOCK_SHG_GAME_LINKS);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $shg->helpers->get_blocks_spaces(get_fields());
    $types = (!empty(get_field('shg_content_types_members', 'options'))) ? get_field('shg_content_types_members', 'options') :[];

    $post = get_post();
    $links_block = (!empty(get_field('shg_game_links_block', $post))) ? get_field('shg_game_links_block', $post) : 'show';
?>
<?php if ((empty(get_option('shg_source')) || get_option('shg_source') == 'members') && $links_block == 'show'): ?>
    <div class="shg-blocks sticky">
        <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
            <div class="container content grid-container">
                <div id="game-link-sticky-origin" class="links-body">
                    <div class="primary">
                        <span>ON THIS PAGE</span>
                    </div>
                    <div class="default">
                        <?php foreach ($types as $type): ?>
                            <?php if (isset($type['shg_content_type_slug_members']) 
                                && !empty($type['shg_content_type_slug_members']) 
                                && $type['shg_content_type_slug_members'] != 'knup_sports'
                                && isset($type['shg_content_type_block_icon_members']['url'])
                                && !empty($type['shg_content_type_block_icon_members']['url'])
                                && isset($type['shg_content_type_block_title_members'])
                                && !empty($type['shg_content_type_block_title_members'])
                            ): ?>
                                <div class="link">
                                    <a href="#block-game-links-<?php echo $type['shg_content_type_slug_members'];?>">
                                        <img src="<?php echo $type['shg_content_type_block_icon_members']['url']; ?>" alt="">
                                        <?php echo $type['shg_content_type_block_title_members'];?>
                                    </a>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
