<?php 
    global $shg;
    $shg = (!empty($shg)) ? $shg : Sportshub_Games::instance();

    $block_styles = [];
    $block_classes = [BLOCK_SHG_GAME_PICKS_GAME];
    $block_game_picks_game = $shg->settings->get_block(BLOCK_SHG_GAME_PICKS_GAME);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $shg->helpers->get_blocks_spaces(get_fields());

    $post = get_post();
    $fields = $block_game_picks_game->get_block_fields($post, $shg);
    $type = (isset($fields['type']) && !empty($fields['type'])) ? $fields['type'] : null;
    $example = (isset($fields['example']) && !empty($fields['example'])) ? $fields['example'] : null;
    $invalid_fields = (isset($fields['invalid_fields']) && !empty($fields['invalid_fields'])) ? $fields['invalid_fields'] : null;

    $block_picks_game_picks = 'game-picks';
    $picks = (is_array(get_field('shg_picks_game', $post->ID)) && count(get_field('shg_picks_game', $post->ID)) > 0) ? get_field('shg_picks_game', $post->ID) : [];
    $types = $shg->helpers->getContentTypeBlock([$block_picks_game_picks]);
?>

<?php if (empty(get_option('shg_source')) || get_option('shg_source') == 'members'): ?>
    <?php if (is_array($picks) && count($picks) > 0): ?>
        <div class="shg-blocks">
            <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
                <div class="container content grid-container">
                    <div class="inner-content">

                        <div class="top-header">
                            <?php if ($type == 'example'): ?>
                                <h2 id="block-game-links-game-picks" class="top-title title-picks">EXAMPLE Game Picks</h2>
                            <?php else: ?>
                                <h2 id="block-game-links-game-picks" class="top-title title-picks"><?php echo $block_game_picks_game->getTitle($block_picks_game_picks, $types, $fields); ?></h2>
                            <?php endif; ?>
                        </div>
                        <div class="picks">
                            <?php
                                if (count($picks) > 6) {
                                    $picks = array_slice($picks, 0, 6);
                                }
                            ?>
                            <?php foreach ($picks as $pick): ?>
                            <div class="pick">
                                <div class="pick-header">
                                    <div class="content">
                                        <div class="handicapper">
                                            <div class="image">
                                                <?php
                                                    $team_visitor_image = $shg->helpers->getNameFile($pick['shg_pick_game_handicapper_image']);
                                                    $team_visitor_alt = (isset($team_visitor_image['alt']) && !empty($team_visitor_image['alt'])) ? $team_visitor_image['alt'] : '';
                                                ?>
                                                <img src="<?php echo $pick['shg_pick_game_handicapper_image_local']; ?>" alt="<?php echo $team_visitor_alt; ?>">
                                            </div>
                                            <div class="description">
                                                <div class="name"><?php echo $pick['shg_pick_game_handicapper_name']; ?></div>
                                                <div class="package"><?php echo $pick['shg_pick_game_handicapper_package']; ?></div>
                                            </div>
                                        </div>
                                        <div class="stats">
                                            <span class="win green"><?php echo $pick['shg_pick_game_handicapper_win']; ?>W</span>
                                            <span class="separator">/</span>
                                            <span class="lose red"><?php echo $pick['shg_pick_game_handicapper_lose']; ?>L</span>
                                            <span class="sport">on <?php echo $pick['shg_pick_game_sport_name']; ?></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="pick-body">
                                    <div class="data">
                                        <div class="status_home"><?php echo $pick['shg_pick_game_sport_acronym']; ?></div>
                                        <div class="date">
                                            <?php
                                                try {
                                                    $d = DateTime::createFromFormat('Y-m-d H:i:s', $pick['shg_pick_game_date']);
                                                    $date_status = $d && $d->format('Y-m-d H:i:s') == $pick['shg_pick_game_date'];

                                                    if ($date_status) {
                                                        echo $d->format('m/d | H:i');
                                                    }
                                                } catch (\Exception $exception) {
                                                    //
                                                }
                                            ?>
                                        </div>
                                        <div class="status_visitor"><?php echo $pick['shg_pick_game_bet']; ?></div>
                                    </div>
                                    <div class="teams">
                                        <div class="team team-a">
                                            <div class="team-logo">
                                                <?php if (isset($pick['shg_pick_game_home_image_local']) && !empty($pick['shg_pick_game_home_image_local'])): ?>
                                                    <?php
                                                        $team_visitor_image = $shg->helpers->getNameFile($pick['shg_pick_game_home_image_local']);
                                                        $team_visitor_alt = (isset($team_visitor_image['alt']) && !empty($team_visitor_image['alt'])) ? $team_visitor_image['alt'] : '';
                                                    ?>
                                                    <img src="<?php echo $pick['shg_pick_game_home_image_local']; ?>" alt="<?php echo $team_visitor_alt; ?>">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="team team-vs">
                                            <div class="vs-logo"><span>vs</span></div>
                                            <?php
                                                $url = (!empty($pick['shg_pick_game_url'])) ? $pick['shg_pick_game_url'] : '#';
                                                $target = '_blank';
                                            ?>
                                        </div>
                                        <div class="team team-b">
                                            <div class="team-logo">
                                                <?php if (isset($pick['shg_pick_game_visitor_image_local']) && !empty($pick['shg_pick_game_visitor_image_local'])): ?>
                                                    <?php
                                                        $team_home_image = $shg->helpers->getNameFile($pick['shg_pick_game_visitor_image_local']);
                                                        $team_home_alt = (isset($team_home_image['alt']) && !empty($team_home_image['alt'])) ? $team_home_image['alt'] : '';
                                                    ?>
                                                    <img src="<?php echo $pick['shg_pick_game_visitor_image_local']; ?>" alt="<?php echo $team_home_alt; ?>">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="footer">
                                    <div class="footer-teaser"><?php echo $pick['shg_pick_game_teaser']; ?></div>
                                    <div class="footer-link">
                                        <?php
                                            $url = (!empty($pick['shg_pick_game_url_profile'])) ? $pick['shg_pick_game_url_profile'] : '#';
                                            $target = '_blank';
                                        ?>
                                        <a href="<?php echo $url; ?>" target="<?php echo $target; ?>" rel="noopener nofollow">
                                            <div class="link">
                                                <span>Get this pick</span>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>

