<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shg_Blocks_Game_Links extends Shg_Blocks_Base
{
    protected $block_name = BLOCK_SHG_GAME_LINKS;
    private $block_folder_name = BLOCK_SHG_GAME_LINKS;
    private $block_title = 'SHG Game Links';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['shg', 'custom', 'game', 'link'];
    private $block_mode = 'preview';
    private $block_category = SHGAMES_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        add_action('wp_enqueue_scripts', [$this, 'enqueue_block_assets']);
        $this->register_block();
    }

    public function enqueue_block_assets() {
        $shg_helpers = new Sportshub_Games_Helpers();
        $css_url = $shg_helpers->webpack('shg_game_links.css');
        wp_enqueue_style(
            'shgames_links_styles',
            $css_url,
            [],
            null,
            'all'
        );
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => SHGAMES_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_assets' => function() {
                    wp_enqueue_script('shgames_scripts');
                },
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => false,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-game-links-primary','slug' => 'color-game-links-primary','color' => '#0160ac'],
            ['name' => 'color-game-links-gray','slug' => 'color-game-links-gray','color' => '#dedede'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.shg-game-links .links-body .default .link, .links-body .default .link',
                'fontSize' => '1rem',
                'fontWeight' => '600',
            ],
            [
                'customSelector' => '.shg-game-links .links-body .primary, .links-body .primary',
                'fontSize' => '1.2rem',
                'fontWeight' => '600',
            ],
        ];
    }
}

$shg_game_links_class = new Shg_Blocks_Game_Links();
$shg_game_links_class->init();

return $shg_game_links_class;
