<?php 
    global $shg;
    $shg = (!empty($shg)) ? $shg : Sportshub_Games::instance();

    $block_styles = [];
    $block_classes = [BLOCK_SHG_GAME_ODDS];
    $block_game_odds = $shg->settings->get_block(BLOCK_SHG_GAME_ODDS);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $shg->helpers->get_blocks_spaces(get_fields());

    $post = get_post();
    $fields = $block_game_odds->get_block_fields($post, $shg);
    $type = (isset($fields['type']) && !empty($fields['type'])) ? $fields['type'] : null;
    $example = (isset($fields['example']) && !empty($fields['example'])) ? $fields['example'] : null;
    $invalid_fields = (isset($fields['invalid_fields']) && !empty($fields['invalid_fields'])) ? $fields['invalid_fields'] : null;

    $block_odds = 'odds';
    $is_config = $shg->helpers->isConfigBlock($block_odds);

    $types = $shg->helpers->getContentTypeBlock(['odds']);
    $odd_data = $block_game_odds->getOdds($post->ID);
?>

<?php if ($is_config): ?>
    <?php if ($type != 'example' && $type != ''): ?>
        <?php
            $params = ['type_game' => $type, 'data' => $example, 'invalid_fields' => $invalid_fields];
            $block_game_odds->getLogDebug($params);
        ?>
    <?php else: ?>
        <?php if (empty(get_option('shg_source')) || get_option('shg_source') == 'members'): ?>
            <div class="shg-blocks">
                <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
                    <div class="container content grid-container">
                        <div class="inner-content">
                            <div class="odd-header">
                                <?php if ($type == 'example'): ?>
                                    <span id="block-game-links-odds" class="odd-title">EXAMPLE Top Handicapper</span>
                                <?php else: ?>
                                    <h2 id="block-game-links-odds" class="odd-title"><?php echo $shg->helpers->getTitle('[home-team] vs [visitor-team] Odds', $post->ID); ?></h2>
                                <?php endif; ?>
                            </div>
                            <div class="odd-content">
                                <div class="odd-body">
                                    <div class="odd-header">
                                        <div class="header-date">
                                            <?php
                                                try {
                                                    if (!empty($odd_data['shg_date_odds'])) {
                                                        $d = DateTime::createFromFormat('Y-m-d H:i:s', $odd_data['shg_date_odds']);
                                                        $date_status = $d && $d->format('Y-m-d H:i:s') == $odd_data['shg_date_odds'];
                                                        
                                                        if ($date_status) {
                                                            echo $d->format('D, M j, H:i a.');
                                                        }
                                                    }
                                                } catch (\Exception $exception) {
                                                    //
                                                }
                                            ?>
                                        </div>
                                        <div class="header-labels">
                                            <div class="spread">spread</div>
                                            <div class="moneyline">moneyline</div>
                                            <div class="over-under">over/under</div>
                                        </div>
                                    </div>
                                    <div class="odd-teams">
                                        <div class="team home-team">
                                            <div class="team-name"><?php echo $shg->helpers->getTitle('[home-team]', $post->ID); ?></div>
                                            <div class="team-stats">
                                                <div class="spread">
                                                    <div class="stats-multi <?php echo $block_game_odds->getStyle($odd_data['shg_home_handicap_spread_odds']); ?>"><?php echo $odd_data['shg_home_handicap_spread_odds']; ?></div>
                                                    <div class="stats-multi <?php echo $block_game_odds->getStyle($odd_data['shg_home_spread_odds']); ?>"><?php echo $odd_data['shg_home_spread_odds']; ?></div>
                                                </div>
                                                <div class="moneyline <?php echo $block_game_odds->getStyle($odd_data['shg_home_money_odds']); ?>"><?php echo $odd_data['shg_home_money_odds']; ?></div>
                                                <div class="over-under">
                                                    <div class="stats-multi <?php echo $block_game_odds->getStyle($odd_data['shg_home_handicap_overunder_odds']); ?>"><?php echo $odd_data['shg_home_handicap_overunder_odds']?></div>
                                                    <div class="stats-multi <?php echo $block_game_odds->getStyle($odd_data['shg_home_overunder_odds']); ?>"><?php echo $odd_data['shg_home_overunder_odds']; ?></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="team visitor-team">
                                            <div class="team-name"><?php echo $shg->helpers->getTitle('[visitor-team]', $post->ID); ?></div>
                                            <div class="team-stats">
                                                <div class="spread">
                                                    <div class="stats-multi <?php echo $block_game_odds->getStyle($odd_data['shg_away_handicap_spread_odds']); ?>"><?php echo $odd_data['shg_away_handicap_spread_odds']?></div>
                                                    <div class="stats-multi <?php echo $block_game_odds->getStyle($odd_data['shg_away_spread_odds']); ?>"><?php echo $odd_data['shg_away_spread_odds']; ?></div>
                                                </div>
                                                <div class="moneyline <?php echo $block_game_odds->getStyle($odd_data['shg_away_money_odds']); ?>"><?php echo $odd_data['shg_away_money_odds']; ?></div>
                                                <div class="over-under">
                                                    <div class="stats-multi <?php echo $block_game_odds->getStyle($odd_data['shg_away_handicap_overunder_odds']); ?>"><?php echo $odd_data['shg_away_handicap_overunder_odds']?></div>
                                                    <div class="stats-multi <?php echo $block_game_odds->getStyle($odd_data['shg_away_overunder_odds']); ?>"><?php echo $odd_data['shg_away_overunder_odds']; ?></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    <?php endif; ?>
<?php endif; ?>
