<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shg_Blocks_Game_Odds extends Shg_Blocks_Base
{
    protected $block_name = BLOCK_SHG_GAME_ODDS;
    private $block_folder_name = BLOCK_SHG_GAME_ODDS;
    private $block_title = 'SHG Game Odds';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['shg', 'custom', 'game', 'odd'];
    private $block_mode = 'preview';
    private $block_category = SHGAMES_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $shg_helpers = new Sportshub_Games_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => SHGAMES_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $shg_helpers->webpack('shg_game_odds.css'),
                'enqueue_assets' => function() {
                    wp_enqueue_style('shgames_styles');
                    wp_enqueue_script('shgames_scripts');
                },
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function get_block_fields($post, $shg) {
        $example_fields = [
            'shg_game_top_handicapper_id' => '71',
            'shg_game_top_handicapper_name' => 'Totals Guru',
            'shg_game_top_handicapper_local_image' => SHGAMES_PLUGIN_URL.'blocks/shg-game-top-handicapper/assets/img/capper.png',
            'shg_game_top_handicapper_description' => "<p>Picks can be found on BestBettor, part of SportsCapping Group.</p><p>The Totals Guru believes there is an unmatched value in over/under wagers.&nbsp; That is why he doesn't play any sides, just totals!</p>",
            'shg_game_results_rank' => '1',
            'shg_sport_name' => 'Basketball',
            'shg_game_results_yesterday' => '100',
            'shg_game_results_lastthreedays' => '90',
            'shg_game_results_lastsevendays' => '-140',
            'shg_game_results_lastthirtydays' => '390',
        ];

        $fields_validate = [];
        
        if ($post->post_type == 'gp_elements') {
            return array_merge($example_fields, [
                'type' => 'example',
            ]);
        }

        $validate = true;
        $custom_fields = [];

        foreach ($example_fields as $key => $value) {
            $custom_fields[$key] = get_field($key, $post->ID);
        }

        $invalid_fields = [];

        foreach ($example_fields as $key => $value) {
            if (!isset($custom_fields[$key]) || empty($custom_fields[$key])) {
                if (!isset($fields_validate[$key]) || (isset($fields_validate[$key]) && $fields_validate[$key] != 'nullable')) {
                    $validate = false;
                    $invalid_fields[$key] = $custom_fields[$key];
                }
            }
        }

        if (!$validate) {
            return array_merge($example_fields, [
                'type' => 'Invalid field validation',
                'example' => $example_fields,
                'invalid_fields' => $invalid_fields,
            ]);
        }

        return array_merge($custom_fields, ['type' => '']);
    }

    public function getOdds($post_id)
    {
        return [
            'shg_game_id_odds' => (!empty(get_field('shg_game_id_odds', $post_id))) ? get_field('shg_game_id_odds', $post_id) : '',
            'shg_external_id_odds' => (!empty(get_field('shg_external_id_odds', $post_id))) ? get_field('shg_external_id_odds', $post_id) : '',
            'shg_sportsbook_odds' => (!empty(get_field('shg_sportsbook_odds', $post_id))) ? get_field('shg_sportsbook_odds', $post_id) : '',
            'shg_date_odds' => (!empty(get_field('shg_date_odds', $post_id))) ? get_field('shg_date_odds', $post_id) : null,
            'shg_home_handicap_spread_odds' => (!empty(get_field('shg_home_handicap_spread_odds', $post_id))) ? get_field('shg_home_handicap_spread_odds', $post_id) : '-',
            'shg_away_handicap_spread_odds' => (!empty(get_field('shg_away_handicap_spread_odds', $post_id))) ? get_field('shg_away_handicap_spread_odds', $post_id) : '-',
            'shg_home_spread_odds' => (!empty(get_field('shg_home_spread_odds', $post_id))) ? get_field('shg_home_spread_odds', $post_id) : '-',
            'shg_away_spread_odds' => (!empty(get_field('shg_away_spread_odds', $post_id))) ? get_field('shg_away_spread_odds', $post_id) : '-',
            'shg_home_money_odds' => (!empty(get_field('shg_home_money_odds', $post_id))) ? get_field('shg_home_money_odds', $post_id) : '-',
            'shg_away_money_odds' => (!empty(get_field('shg_away_money_odds', $post_id))) ? get_field('shg_away_money_odds', $post_id) : '-',
            'shg_home_handicap_overunder_odds' => (!empty(get_field('shg_home_handicap_overunder_odds', $post_id))) ? get_field('shg_home_handicap_overunder_odds', $post_id) : '-',
            'shg_away_handicap_overunder_odds' => (!empty(get_field('shg_away_handicap_overunder_odds', $post_id))) ? get_field('shg_away_handicap_overunder_odds', $post_id) : '-',
            'shg_home_overunder_odds' => (!empty(get_field('shg_home_overunder_odds', $post_id))) ? get_field('shg_home_overunder_odds', $post_id) : '-',
            'shg_away_overunder_odds' => (!empty(get_field('shg_away_overunder_odds', $post_id))) ? get_field('shg_away_overunder_odds', $post_id) : '-',
        ];
    }

    public function getStyle($value)
    {
        if (substr($value, 0, 1) == '-') {
            return 'bg-green';
        }

        if (substr($value, 0, 1) == '+') {
            return 'bg-grey';
        }

        return '';
    }
}

$shg_game_odds_class = new Shg_Blocks_Game_Odds();
$shg_game_odds_class->init();

return $shg_game_odds_class;
