<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shg_Blocks_Game_Picks extends Shg_Blocks_Base
{
    protected $block_name = BLOCK_SHG_GAME_PICKS_GAME;
    private $block_folder_name = BLOCK_SHG_GAME_PICKS_GAME;
    private $block_title = 'SHG Game Picks';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['shg', 'custom', 'game', 'pick'];
    private $block_mode = 'preview';
    private $block_category = SHGAMES_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $shg_helpers = new Sportshub_Games_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => SHGAMES_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $shg_helpers->webpack('shg_game_picks_game.css'),
                'enqueue_assets' => function() {
                    wp_enqueue_style('shgames_styles');
                    wp_enqueue_script('shgames_scripts');
                },
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function get_block_fields($post, $shg) {
        $example_fields = [
            'shg_game_top_handicapper_id' => '71',
            'shg_game_top_handicapper_name' => 'Totals Guru',
            'shg_game_top_handicapper_local_image' => SHGAMES_PLUGIN_URL.'blocks/shg-game-top-handicapper/assets/img/capper.png',
            'shg_game_top_handicapper_description' => "<p>Picks can be found on BestBettor, part of SportsCapping Group.</p><p>The Totals Guru believes there is an unmatched value in over/under wagers.&nbsp; That is why he doesn't play any sides, just totals!</p>",
            'shg_game_results_rank' => '1',
            'shg_sport_name' => 'Basketball',
            'shg_game_results_yesterday' => '100',
            'shg_game_results_lastthreedays' => '90',
            'shg_game_results_lastsevendays' => '-140',
            'shg_game_results_lastthirtydays' => '390',
        ];

        $fields_validate = [];
        
        if ($post->post_type == 'gp_elements') {
            return array_merge($example_fields, [
                'type' => 'example',
            ]);
        }

        $validate = true;
        $custom_fields = [];

        foreach ($example_fields as $key => $value) {
            $custom_fields[$key] = get_field($key, $post->ID);
        }

        $invalid_fields = [];

        foreach ($example_fields as $key => $value) {
            if (!isset($custom_fields[$key]) || empty($custom_fields[$key])) {
                if (!isset($fields_validate[$key]) || (isset($fields_validate[$key]) && $fields_validate[$key] != 'nullable')) {
                    $validate = false;
                    $invalid_fields[$key] = $custom_fields[$key];
                }
            }
        }

        if (!$validate) {
            return array_merge($example_fields, [
                'type' => 'Invalid field validation',
                'example' => $example_fields,
                'invalid_fields' => $invalid_fields,
            ]);
        }

        return array_merge($custom_fields, ['type' => '']);
    }

    public function getTitle($type, $types, $fields, $post_id = null)
    {
        if ($type == 'picks') {
            if (isset($types[$type]['shg_content_type_title_members']) && !empty($types[$type]['shg_content_type_title_members'])) {
                return $this->setPlaceholders($types[$type]['shg_content_type_title_members'], $fields);
            }

            return 'Top Picks';
        }

        if ($type == 'top-handicapper') {
            if (isset($types[$type]['shg_content_type_title_members']) && !empty($types[$type]['shg_content_type_title_members'])) {
                return $this->setPlaceholders($types[$type]['shg_content_type_title_members'], $fields);
            }

            return 'Top Handicapper';
        }

        if ($type == 'odds') {
            if (isset($types[$type]['shg_content_type_title_members']) && !empty($types[$type]['shg_content_type_title_members'])) {
                return $this->setPlaceholders($types[$type]['shg_content_type_title_members'], $fields);
            }

            return 'Odds';
        }

        if ($type == 'game-picks') {
            if (isset($types[$type]['shg_content_type_title_members']) && !empty($types[$type]['shg_content_type_title_members'])) {
                $shg_helpers = new Sportshub_Games_Helpers();
                return $shg_helpers->getTitle($types[$type]['shg_content_type_title_members'], $post_id);
            }

            return 'Game Picks';
        }

        return '';
    }

    public function setPlaceholders($text, $fields)
    {
        $text = str_replace('[author]', $fields['shg_game_top_handicapper_name'], $text);
        $text = str_replace('[sport]', $fields['shg_sport_name'], $text);

        return $text;
    }
}

$shg_game_picks_class = new Shg_Blocks_Game_Picks();
$shg_game_picks_class->init();

return $shg_game_picks_class;
