<?php
/**
 * SportsHub Games
 *
 * @package SHGAMES
 * @author  IT
 * @version 1.1.4
 *
 * @wordpress-plugin
 * Plugin Name: SportsHub Games
 * Plugin URI:  https://www.sportshub.com
 * Description: SportsHub Network Games Importer
 * Version:     1.1.4
 * Author:      IT
 * Author URI:  https://www.sportshub.com
 * Text Domain: sportshub-games
 * Domain Path: /languages
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * HELPER COMMENT START
 * 
 * This file contains the main information about the plugin.
 * It is used to register all components necessary to run the plugin.
 * 
 * The comment above contains all information about the plugin 
 * that are used by WordPress to differenciate the plugin and register it properly.
 * It also contains further PHPDocs parameter for a better documentation
 * 
 * The function SHGAMES() is the main function that you will be able to 
 * use throughout your plugin to extend the logic. Further information
 * about that is available within the sub classes.
 * 
 * HELPER COMMENT END
 */

// Plugin name
define('SHGAMES_NAME','SportsHub Games');
define('SHGAMES_NAME_SLUG', 'sportshub-games');

// Plugin version
define('SHGAMES_VERSION', '1.1.4');

// REDIS
define('REDIS_GROUP_SHGAMES', 'sh_games');

if (!defined('SHGAMES_REDIS_TIMEOUT')) {
    define('SHGAMES_REDIS_TIMEOUT', 3600);
}

// UPLOAD DIR
$plugin_upload_dir = wp_upload_dir()['basedir'] . '/' . str_replace(' ', '_', SHGAMES_NAME);
define('SHGAMES_PLUGIN_LOG_DIR', $plugin_upload_dir);

// Plugin Root File
define('SHGAMES_PLUGIN_FILE', __FILE__);

// Plugin base
define('SHGAMES_PLUGIN_BASE', plugin_basename( SHGAMES_PLUGIN_FILE));

// Plugin Folder Path
define('SHGAMES_PLUGIN_DIR', plugin_dir_path( SHGAMES_PLUGIN_FILE));

// Plugin Folder URL
define('SHGAMES_PLUGIN_URL', plugin_dir_url( SHGAMES_PLUGIN_FILE));

define('BLOCK_SHG_GAME', 'shg-game');
define('BLOCK_SHG_GAME_TOP_HANDICAPPER', 'shg-game-top-handicapper');
define('BLOCK_SHG_GAME_LINKS', 'shg-game-links');
define('BLOCK_SHG_GAME_PICKS', 'shg-game-picks');
define('BLOCK_SHG_GAME_ODDS', 'shg-game-odds');

/**
 * Load the main class for the core functionality
 */
require_once SHGAMES_PLUGIN_DIR . 'core/class-sportshub-games.php';
require_once SHGAMES_PLUGIN_DIR . 'blocks/shg-blocks-base.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  IT
 * @since   1.0.0
 * @return  object|Sportshub_Games
 */
function SHGAMES() {
    $shg = Sportshub_Games::instance();
    $shg_base_style = $shg->helpers->webpack('shg_base_style.css');

    add_action('init', function () use ($shg_base_style) {
        wp_enqueue_style('shg_base_style', $shg_base_style, [], true);
    });

    return $shg;
}

$shg = SHGAMES();
update_option('shg_slug', $shg->get_slug(false));
