<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shg_Blocks_Game extends Shg_Blocks_Base
{
    protected $block_name = BLOCK_SHG_GAME;
    private $block_folder_name = BLOCK_SHG_GAME;
    private $block_title = 'SHG Game';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['shg', 'custom', 'game'];
    private $block_mode = 'preview';
    private $block_category = SHGAMES_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $shg_helpers = new Sportshub_Games_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => SHGAMES_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $shg_helpers->webpack('shg_game.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => false,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function get_block_fields($post, $shg) {
        $example_fields = [
            'shg_sport_id' => '1',
            'shg_category' => '1',
            'shg_game_date' => '2023-09-15 10:25:00',
            'shg_home_city' => 'Kansas City',
            'shg_home_team' => 'Chiefs',
            'shg_home_score' => '21',
            'shg_home_local_url' => SHGAMES_PLUGIN_URL.'blocks/shg-game/assets/img/chiefs.png',
            'shg_home_money_odds' => '-288',
            'shg_visitor_city' => 'Detroit',
            'shg_visitor_team' => 'Lions',
            'shg_visitor_score' => '3',
            'shg_visitor_local_url' => SHGAMES_PLUGIN_URL.'blocks/shg-game/assets/img/lions.png',
            'shg_away_money_odds' => '+236',
        ];

        $fields_validate = [
            'shg_category' => 'nullable',
            'shg_home_score' => 'nullable',
            'shg_visitor_score' => 'nullable',
        ];

        $example_fields['shg_home_city'] = $example_fields['shg_home_city'];
        $example_fields['shg_home_team'] = $example_fields['shg_home_team'];

        $example_fields['shg_visitor_city'] = $example_fields['shg_visitor_city'];
        $example_fields['shg_visitor_team'] = $example_fields['shg_visitor_team'];

        $sports_categories = $shg->helpers->get_sporst_categories_titles(true);
        
        if ($post->post_type == 'gp_elements') {
            if (is_array($sports_categories) && count($sports_categories) > 0) {
                $title = $sports_categories[$example_fields['shg_sport_id']];
            } else {
                $title = null;
            }

            return array_merge($example_fields, [
                'type' => 'example',
                'title' => $title
            ]);
        }

        $validate = true;
        $custom_fields = [];

        foreach ($example_fields as $key => $value) {
            $custom_fields[$key] = get_field($key, $post->ID);
        }

        $custom_fields['shg_home_city'] = $custom_fields['shg_home_city'];
        $custom_fields['shg_home_team'] = $custom_fields['shg_home_team'];
        $custom_fields['shg_visitor_city'] = $custom_fields['shg_visitor_city'];
        $custom_fields['shg_visitor_team'] = $custom_fields['shg_visitor_team'];

        $invalid_fields = [];

        foreach ($example_fields as $key => $value) {
            if (!isset($custom_fields[$key]) || empty($custom_fields[$key])) {
                if (!isset($fields_validate[$key]) || (isset($fields_validate[$key]) && $fields_validate[$key] != 'nullable')) {
                    $validate = false;
                    $invalid_fields[$key] = $custom_fields[$key];
                }
            }
        }

        if (!$validate) {
            return array_merge($example_fields, [
                'type' => 'Invalid field validation',
                'example' => $example_fields,
                'invalid_fields' => $invalid_fields,
            ]);
        }

        $sport_category_index = $custom_fields['shg_sport_id'];
        if (isset($custom_fields['shg_category']) && !empty($custom_fields['shg_category'])) {
            $sport_category_index = $custom_fields['shg_sport_id'].'-'.$custom_fields['shg_category'];
        }

        if (is_array($sports_categories) && count($sports_categories) > 0) {
            $custom_fields['title'] = (!empty($sports_categories[$sport_category_index]))
                ? $sports_categories[$sport_category_index]
                : $sports_categories[$custom_fields['shg_sport_id']];
        } else {
            $custom_fields['title'] = null;
        }

        return array_merge($custom_fields, ['type' => '']);
    }
}

$shg_game_class = new Shg_Blocks_Game();
$shg_game_class->init();

return $shg_game_class;
