<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shg_Blocks_Game_Top_Handicapper extends Shg_Blocks_Base
{
    protected $block_name = BLOCK_SHG_GAME_TOP_HANDICAPPER;
    private $block_folder_name = BLOCK_SHG_GAME_TOP_HANDICAPPER;
    private $block_title = 'SHG Game Top Handicapper';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['shg', 'custom', 'game', 'top', 'handicapper'];
    private $block_mode = 'preview';
    private $block_category = SHGAMES_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;

    public function init() {
        $this->register_block();
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $shg_helpers = new Sportshub_Games_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => SHGAMES_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_style' => $shg_helpers->webpack('shg_game_top_handicapper.css'),
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => true,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }
}

$shg_game_top_handicapper_class = new Shg_Blocks_Game_Top_Handicapper();
$shg_game_top_handicapper_class->init();

return $shg_game_top_handicapper_class;
