<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shg_Blocks_Base
{
    public function get_block_name() {
        return $this->block_name;
    }

    public function get_block_title() {
        return $this->block_title;
    }

    public function is_caching() {
        return $this->is_caching;
    }

    public function is_config() {
        return $this->is_config;
    }

    public function get_config() {
        $config = [
            'page_title' => '',
            'menu_title' => '',
            'order' => '',
        ];

        if ($this->is_config) {
            $config['page_title'] = $this->config_page_title;
            $config['menu_title'] = $this->config_menu_title;
            $config['order'] = $this->config_menu_order;
        }

        return $config;
    }

    public function get_log_debug($params) {
        global $shg;
        $shg = (!empty($shg)) ? $shg : Sportshub_Games::instance();

        if (isset($params['type_game']) && $shg->helpers->shg_debug_blocks_games($params)) {
            echo '<div class="shg-blocks">';
            echo '<!-- SHG Games/SHG Game: '.$params['type_game'].' ';
            print_r($params['data']);
            echo '-->';

            if (isset($params['invalid_fields']) && is_array($params['invalid_fields']) && count($params['invalid_fields']) > 0) {
                echo '<!-- Invalid Fields ';
                print_r($params['invalid_fields']);
                echo '-->';
            }

            echo '</div>';
        }
    }
}
