<?php 
    global $shg;
    $shg = (!empty($shg)) ? $shg : Sportshub_Games::instance();

    $block_styles = [];
    $block_classes = [BLOCK_SHG_GAME];
    $block_game = $shg->settings->get_block(BLOCK_SHG_GAME);

    if (!empty($block['backgroundColor'])) {
        $block_classes[] = 'has-background';
        $block_classes[] = 'has-'.$block['backgroundColor'].'-background-color';
    }

    if (!empty($block['style']['color']['background'])) {
        $block_styles[] = 'background-color: '.$block['style']['color']['background'].';';
    }

    $position_block = $shg->helpers->get_blocks_spaces(get_fields());

    $post = get_post();
    $fields = $block_game->get_block_fields($post, $shg);
    $type = (isset($fields['type']) && !empty($fields['type'])) ? $fields['type'] : null;
    $shg_game_picks_count = (isset($fields['shg_game_picks_count']) && !empty($fields['shg_game_picks_count'])) ? $fields['shg_game_picks_count'] : 0;
    $shg_game_url = (isset($fields['shg_game_url']) && !empty($fields['shg_game_url'])) ? $fields['shg_game_url'] : '#';
    $target = '_blank';
    $example = (isset($fields['example']) && !empty($fields['example'])) ? $fields['example'] : null;
    $invalid_fields = (isset($fields['invalid_fields']) && !empty($fields['invalid_fields'])) ? $fields['invalid_fields'] : null;
?>

<?php if ($type != 'example' && $type != ''): ?>
    <?php
        $params = ['type_game' => $type, 'data' => $example, 'invalid_fields' => $invalid_fields];
        $block_game->get_log_debug($params);
    ?>
<?php else: ?>
    <?php if (empty(get_option('shg_source')) || get_option('shg_source') == 'members'): ?>
        <div class="shg-blocks">
            <div class="<?php echo esc_attr(join(' ', $block_classes)); ?>" style="<?php echo $position_block . esc_attr(join(' ', $block_styles)); ?>">
                <div class="content">
                    <div class="game">
                        <div class="game-header">
                            <span class="teams">
                                <?php if ($type == 'example'): ?>
                                    <span class="team">EXAMPLE</span>
                                <?php endif; ?>
                                <?php $shg_home_team = (is_array($fields['shg_home_team']) && isset($fields['shg_home_team'][0])) ? $fields['shg_home_team'][0] : $fields['shg_home_team']; ?>
                                <?php $shg_visitor_team = (is_array($fields['shg_visitor_team']) && isset($fields['shg_visitor_team'][0])) ? $fields['shg_visitor_team'][0] : $fields['shg_visitor_team']; ?>
                                <span class="team"><?php echo $shg_home_team; ?></span>
                                <span class="vs">vs</span>
                                <span class="team"><?php echo $shg_visitor_team; ?></span>
                            </span>
                            <span class="date">
                                <span class="sport"><?php echo $fields['title']; ?></span>
                                <span class="separator"> <?php echo (!empty($fields['title'])) ? '•' : ''; ?></span>
                                <span class="time"> <?php echo date('D, M j, H:i a.', strtotime($fields['shg_game_date'])); ?></span>
                            </span>
                        </div>
                        <div class="game-body">
                            <div class="content-body">
                                <div class="content-teams">
                                    <div class="team-home">
                                        <div class="team">
                                            <div class="team-name">
                                                <span class="name">
                                                    <?php echo $shg_home_team; ?>
                                                </span>
                                                <div class="stats">
                                                    <span class="pill <?php echo ($fields['shg_home_money_odds'] < 0) ? 'success' : 'info'; ?>">ML: <?php echo $fields['shg_home_money_odds']; ?></span>
                                                </div>
                                            </div>
                                            <div class="team-logo">
                                                <?php if (isset($fields['shg_home_local_url']) && !empty($fields['shg_home_local_url'])): ?>
                                                    <?php
                                                        $team_home_image = $shg->helpers->getNameFile($fields['shg_home_local_url']);
                                                        $team_home_alt = (isset($team_home_image['alt']) && !empty($team_home_image['alt'])) ? $team_home_image['alt'] : '';
                                                    ?>
                                                    <img src="<?php echo $fields['shg_home_local_url']; ?>" alt="<?php echo $team_home_alt; ?>">
                                                <?php endif; ?>
                                            </div>
                                            <div class="team-score">
                                                <span class="score"><?php echo $fields['shg_home_score']; ?></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="team-separator"></div>
                                    <div class="team-visitor">
                                        <div class="team">
                                            <div class="team-score">
                                                <span class="score"><?php echo $fields['shg_visitor_score']; ?></span>
                                            </div>
                                            <div class="team-logo">
                                                <?php if (isset($fields['shg_visitor_local_url']) && !empty($fields['shg_visitor_local_url'])): ?>
                                                    <?php
                                                        $team_visitor_image = $shg->helpers->getNameFile($fields['shg_visitor_local_url']);
                                                        $team_visitor_alt = (isset($team_visitor_image['alt']) && !empty($team_visitor_image['alt'])) ? $team_visitor_image['alt'] : '';
                                                    ?>
                                                    <img src="<?php echo $fields['shg_visitor_local_url']; ?>" alt="<?php echo $team_visitor_alt; ?>">
                                                <?php endif; ?>
                                            </div>
                                            <div class="team-name">
                                                <span class="name"><?php echo $shg_visitor_team; ?></span>
                                                <div class="stats">
                                                    <span class="pill <?php echo ($fields['shg_away_money_odds'] < 0) ? 'success' : 'info'; ?>">ML: <?php echo $fields['shg_away_money_odds']; ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php if ($shg_game_picks_count > 0): ?>
                                    <div class="footer">
                                    <div class="footer-link">
                                        <a href="<?php echo $shg_game_url; ?>" target="<?php echo $target; ?>" rel="noopener nofollow">
                                            <div class="link">
                                                <span><?php echo $shg_game_picks_count; ?> picks</span>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?>
