<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

class Shg_Blocks_Game extends Shg_Blocks_Base
{
    protected $block_name = BLOCK_SHG_GAME;
    private $block_folder_name = BLOCK_SHG_GAME;
    private $block_title = 'SHG Game';
    private $block_description = '';
    private $block_icon = 'admin-links';
    private $block_keywords = ['shg', 'custom', 'game'];
    private $block_mode = 'preview';
    private $block_category = SHGAMES_NAME_SLUG;
    protected $is_caching = false;
    protected $is_config = false;
    protected $is_styles_load = true;

    public function init() {
        add_action('wp_enqueue_scripts', [$this, 'enqueue_block_assets']);
        $this->register_block();
    }

    public function enqueue_block_assets() {
        $shg_helpers = new Sportshub_Games_Helpers();
        $css_url = $shg_helpers->webpack('shg_game.css');
        wp_enqueue_style(
            'shgames_styles',
            $css_url,
            [],
            null,
            'all'
        );
    }

    private function register_block() {
        if (function_exists('acf_register_block_type')) {
            $shg_helpers = new Sportshub_Games_Helpers();
            acf_register_block_type([
                'name' => $this->block_name,
                'title' => __($this->block_title),
                'description' => __($this->block_description),
                'category' => $this->block_category,
                'icon' => $this->block_icon,
                'keywords' => $this->block_keywords,
                'mode' => $this->block_mode,
                'render_template' => SHGAMES_PLUGIN_DIR . "/blocks/".$this->block_folder_name."/template.php",
                'enqueue_assets' => function() {
                    wp_enqueue_script('shgames_scripts');
                },
                'supports' => [
                    'jsx' => true,
			        'color' => [
                        'background' => false,
                        'gradients'  => false,
                        'text' => false,
                    ],
                ],
            ]);
        }
    }

    public function get_block_fields($post, $shg) {
        $example_fields = [
            'shg_sport_id' => '1',
            'shg_league' => '23',
            'shg_game_date' => '2023-09-15 10:25:00',
            'shg_home_team' => 'Chiefs',
            'shg_home_score' => '21',
            'shg_home_local_url' => SHGAMES_PLUGIN_URL.'blocks/shg-game/assets/img/chiefs.png',
            'shg_home_money_odds' => '-288',
            'shg_visitor_team' => 'Lions',
            'shg_visitor_score' => '3',
            'shg_visitor_local_url' => SHGAMES_PLUGIN_URL.'blocks/shg-game/assets/img/lions.png',
            'shg_away_money_odds' => '+236',
            'shg_game_picks_count' => '0',
            'shg_game_url' => '#',

        ];

        $fields_validate = [
            'shg_league' => 'nullable',
            'shg_home_score' => 'nullable',
            'shg_visitor_score' => 'nullable',
            'shg_game_picks_count' => 'nullable',
            'shg_game_url' => 'nullable',
        ];

        $example_fields['shg_home_team'] = $example_fields['shg_home_team'];
        $example_fields['shg_visitor_team'] = $example_fields['shg_visitor_team'];

        $sport_leagues_names = [];
        if (function_exists('shMappingSportsLeaguesNamesConverter')) {
            $sport_leagues_names = shMappingSportsLeaguesNamesConverter();
        }
        
        if ($post->post_type == 'gp_elements') {
            $title = null;

            if (isset($sport_leagues_names['sports']) && is_array($sport_leagues_names['sports']) && count($sport_leagues_names['sports']) > 0) {
                if (isset($sport_leagues_names['sports'][$example_fields['shg_sport_id']])) {
                    $title = $sport_leagues_names['sports'][$example_fields['shg_sport_id']];
                }
            }

            return array_merge($example_fields, [
                'type' => 'example',
                'title' => $title
            ]);
        }

        $validate = true;
        $custom_fields = [];

        foreach ($example_fields as $key => $value) {
            $custom_fields[$key] = get_field($key, $post->ID);
        }

        $custom_fields['shg_home_team'] = $custom_fields['shg_home_team'];
        $custom_fields['shg_visitor_team'] = $custom_fields['shg_visitor_team'];

        $invalid_fields = [];

        foreach ($example_fields as $key => $value) {
            if (!isset($custom_fields[$key]) || empty($custom_fields[$key])) {
                if (!isset($fields_validate[$key]) || (isset($fields_validate[$key]) && $fields_validate[$key] != 'nullable')) {
                    $validate = false;
                    $invalid_fields[$key] = $custom_fields[$key];
                }
            }
        }

        if (!$validate) {
            return array_merge($example_fields, [
                'type' => 'Invalid field validation',
                'example' => $example_fields,
                'invalid_fields' => $invalid_fields,
            ]);
        }

        $custom_fields['title'] = null;
        if (is_array($sport_leagues_names) && count($sport_leagues_names) > 0) {
            if (isset($custom_fields['shg_league']) && !empty($custom_fields['shg_league'])) {
                if (isset($sport_leagues_names['leagues'][$custom_fields['shg_league']]) && !empty($sport_leagues_names['leagues'][$custom_fields['shg_league']])) {
                    $custom_fields['title'] = $sport_leagues_names['leagues'][$custom_fields['shg_league']];
                } elseif (isset($sport_leagues_names['sports'][$custom_fields['shg_sport_id']]) && !empty($sport_leagues_names['sports'][$custom_fields['shg_sport_id']])) {
                    $custom_fields['title'] = $sport_leagues_names['sports'][$custom_fields['shg_sport_id']];
                }
            } else {
                if (isset($sport_leagues_names['sports'][$custom_fields['shg_sport_id']]) && !empty($sport_leagues_names['sports'][$custom_fields['shg_sport_id']])) {
                    $custom_fields['title'] = $sport_leagues_names['sports'][$custom_fields['shg_sport_id']];
                }
            }
        }

        return array_merge($custom_fields, ['type' => '']);
    }

    public function getColorsToloadGeneratePress() {
        return [
            ['name' => 'color-game-header-bg','slug' => 'color-game-header-bg','color' => '#0160ac'],
            ['name' => 'color-game-header-color','slug' => 'color-game-header-color','color' => '#ffffff'],
            ['name' => 'color-game-header-border','slug' => 'color-game-header-border','color' => '#3a96e0'],
            ['name' => 'color-game-team-vs','slug' => 'color-game-team-vs','color' => '#00bc00'],
            ['name' => 'color-game-body','slug' => 'color-game-body','color' => '#dedede'],
            ['name' => 'color-game-score-bg','slug' => 'color-game-score-bg','color' => '#ffffff'],
            ['name' => 'color-game-stats-color','slug' => 'color-game-stats-color','color' => '#ffffff'],
            ['name' => 'color-game-stats-success','slug' => 'color-game-stats-success','color' => '#00bc00'],
            ['name' => 'color-game-stats-info','slug' => 'color-game-stats-info','color' => '#1eb5d0'],
            ['name' => 'color-game-stats-info-dark','slug' => 'color-game-stats-info-dark','color' => '#0056a1'],
        ];
    }

    public function getStylesToloadGeneratePress() {
        return [
            [
                'customSelector' => '.shg-game .game-header .teams .team',
                'fontWeight' => '600',
                'fontSize' => '2rem',
                'fontSizeTablet' => '1.8rem',
                'fontSizeMobile' => '1.5rem',
                'LineHeight' => '1.8rem',
                'LineHeightTablet' => '1.3rem',
                'LineHeightMobile' => '1.1rem',
            ],
            [
                'customSelector' => '.shg-game .game-header .teams .vs',
                'fontSize' => '1.4rem',
                'fontSizeMobile' => '1.2rem',
                'fontWeight' => '600',
            ],
            [
                'customSelector' => '.shg-game .game-header .date',
                'fontSize' => '1rem',
                'fontSizeMobile' => '0.8rem',
            ],
            [
                'customSelector' => '.shg-game .game-header .date .sport',
                'fontWeight' => '500',
            ],
            [
                'customSelector' => '.shg-game .game-body .content-teams .team .city',
                'fontWeight' => '600',
                'fontSize' => '1.25rem',
                'fontSizeTablet' => '1rem',
                'fontSizeMobile' => '1.25rem',
                'LineHeight' => '1.3rem',
            ],
            [
                'customSelector' => '.shg-game .game-body .content-teams .team .name',
                'fontWeight' => '700',
                'fontSize' => '1.8rem',
                'fontSizeTablet' => '1.5rem',
                'fontSizeMobile' => '1.8rem',
            ],
            [
                'customSelector' => '.shg-game .game-body .content-teams .team .team-score .score',
                'fontWeight' => '600',
                'fontSize' => '2rem',
                'fontSizeTablet' => '1.5rem',
            ],
            [
                'customSelector' => '.shg-game .game-body .content-teams .team .team-name .stats .pill',
                'fontWeight' => '600',
                'fontSize' => '1rem',
            ],
        ];
    }
}

$shg_game_class = new Shg_Blocks_Game();
$shg_game_class->init();

return $shg_game_class;
