<?php
/**
 * Template Name: Handicapper
 * Post Type: Handicapper
 */

get_header();

?>

<main id="site-content" role="main" class="handicapper-main">

    <?php

        $bets_stats = maybe_unserialize(get_post_meta(get_the_ID(), 'bets_stats', true));
        $top_strikes = maybe_unserialize(get_post_meta(get_the_ID(), 'top_strikes', true));
        $handicapper_basic_data = maybe_unserialize(get_post_meta(get_the_ID(), 'handicapper_basic_data', true));
        $today_picks = maybe_unserialize(get_post_meta(get_the_ID(), 'today_picks', true));

        $url_handicapper = get_field('shh_data_url', 'options'); 
        $base_url = explode('api', $url_handicapper)[0];
        $final_url_handicapper = $base_url . 'handicapper-summary/' .$handicapper_basic_data['slug'];

        if (have_posts()) {
            $lapse = [
                'yesterday' => 'Yesterday',
                'lastthreeDays' => 'Last 3 Days',
                'lastSevenDays' => 'Last 7 Days',
                'lastThirtyDays' => 'Last 30 Days',
            ];

        while (have_posts()) {
            the_post();

            $title = get_the_title();

            $profile_position = stripos($title, 'Profile');

            if ($profile_position !== false) {
                $title = trim(substr($title, 0, $profile_position));
            }
        
    ?>
            <article class="type-handicapper" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <h1 class="shh-title"><?php the_title();?></h1>

                <!-- Deinymar -->

                <section class="handicapper-header grid-container container">
                    <div class="handicapper-wrapper handicapper-header-wrapper">
                        <div class="handicapper-card">
                            <div class="handicapper-card-header">
                                <div class="handicapper-card-info">
                                <?php $capper_image = (!empty(get_the_post_thumbnail_url())) ? get_the_post_thumbnail_url() : null; ?>
                                <?php if (!empty($capper_image)): ?>
                                    <img class="handicapper-img" src="<?php echo $capper_image; ?>" alt="handicapper_image">
                                <?php endif; ?>
                                    <p class="handicapper-name"><?php echo $title; ?></p>
                                </div>
                                <div class="handicapper-card-desc">
                                <?php
                                    echo get_post_meta(get_the_ID(), 'handicapper_bio', true);
                                 ?>
                                </div>
                            </div>
                            <div class="handicapper-card-stats">
                                <div class="handicapper-card-stats-info">
                                    <div class="handicapper-card-stats-info-top">
                                        <p><span class="handicapper-bold">Top Strikes:</span> <?php echo esc_html($top_strikes['sport_or_league_name'])?></p>
                                    </div>
                                    <div class="handicapper-card-stats-info-bottom">
                                        <div class="handicapper-card-stats-info-left">
                                            <div>
                                                <p><span class="handicapper-bold">Spread:</span></p>
                                                <p>W <?php echo esc_html($bets_stats['spread']['win'])?> - L <?php echo esc_html($bets_stats['spread']['lose'])?> <span class="handicapper-bold">(<?php echo esc_html($bets_stats['spread']['total'])?>)</span></p>
                                            </div>
                                            <div>
                                                <p><span class="handicapper-bold">ML:</span></p>
                                                <p>W <?php echo esc_html($bets_stats['money line']['win'])?> - L <?php echo esc_html($bets_stats['money line']['lose'])?> <span class="handicapper-bold">(<?php echo esc_html($bets_stats['money line']['total'])?>)</span></p>
                                            </div>
                                            <div>
                                                <p><span class="handicapper-bold">Total:</span></p>
                                                <p>W <?php echo esc_html($bets_stats['totals']['win'])?> - L <?php echo esc_html($bets_stats['totals']['lose'])?> <span class="handicapper-bold">(<?php echo esc_html($bets_stats['totals']['total'])?>)</span></p>
                                            </div>
                                        </div>
                                        <div class="handicapper-card-stats-info-right">
                                            <div>
                                                <p><span class="handicapper-bold">Win:</span> <?php echo esc_html($bets_stats['complete_totals']['win'])?> </p>
                                                <p><span class="handicapper-bold">Loses:</span> <?php echo esc_html($bets_stats['complete_totals']['lose'])?></p>
                                            </div>
                                            <div>
                                                <p><span class="handicapper-bold">Profit:</span> <?php echo esc_html($bets_stats['complete_totals']['total'])?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="handicapper-card-stats-cta">
                                        <a href="<?php echo $final_url_handicapper; ?>" target="_blank" rel="noreferrer">All Stats</a>
                                </div>
                            </div>
                        </div>
                        <div class="handicappers-day-wrapper">
                            <div class="handicappers-day">
                                <div class="handicappers-day-info">
                                    <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/1day.webp'; ?>" alt="Example Image">
                                    <div>
                                        <p class="handicappers-day-title">Handicapper 1 Day </p>
                                        <p class="handicappers-day-desc">Handicapper subscription for 1 day</p>
                                    </div>
                                </div>
                                <div class="handicappers-day-price">
                                    <p>$25</p>
                                </div>
                                <div class="handicappers-day-cta">
                                    <a href="<?php echo $final_url_handicapper; ?>" target="_blank" rel="noreferrer">Buy now</a>
                                    <a href="<?php echo $final_url_handicapper; ?>" target="_blank" rel="noreferrer">Buy with points</a>
                                </div>
                            </div>

                            <div class="handicappers-day">
                                <div class="handicappers-day-info">
                                    <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/3day.webp'; ?>" alt="Example Image">
                                    <div>
                                        <p class="handicappers-day-title">Handicapper 3 Days </p>
                                        <p class="handicappers-day-desc">Handicapper subscription for 3 days</p>
                                    </div>
                                </div>
                                <div class="handicappers-day-price">
                                    <p>$55</p>
                                </div>
                                <div class="handicappers-day-cta">
                                    <a href="<?php echo $final_url_handicapper; ?>" target="_blank" rel="noreferrer">Buy now</a>
                                    <a href="<?php echo $final_url_handicapper; ?>" target="_blank" rel="noreferrer">Buy with points</a>
                                </div>
                            </div>

                            <div class="handicappers-day">
                                <div class="handicappers-day-info">
                                    <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/7day.webp'; ?>" alt="Example Image">
                                    <div>
                                        <p class="handicappers-day-title">Handicapper 7 Days </p>
                                        <p class="handicappers-day-desc">Handicapper subscription for 7 days</p>
                                    </div>
                                </div>
                                <div class="handicappers-day-price">
                                    <p>$95</p>
                                </div>
                                <div class="handicappers-day-cta">
                                    <a href="<?php echo $final_url_handicapper; ?>" target="_blank" rel="noreferrer">Buy now</a>
                                    <a href="<?php echo $final_url_handicapper; ?>" target="_blank" rel="noreferrer">Buy with points</a>
                                </div>
                            </div>

                            <div class="handicappers-day">
                                <div class="handicappers-day-info">
                                    <img src="<?php echo plugin_dir_url(__FILE__) . '../assets/images/30days.webp'; ?>" alt="Example Image">
                                    <div>
                                        <p class="handicappers-day-title">Handicapper 30 Days </p>
                                        <p class="handicappers-day-desc">Handicapper subscription for 30 days</p>
                                    </div>
                                </div>
                                <div class="handicappers-day-price">
                                    <p>$295</p>
                                </div>
                                <div class="handicappers-day-cta">
                                    <a href="<?php echo $final_url_handicapper; ?>" target="_blank" rel="noreferrer">Buy now</a>
                                    <a href="<?php echo $final_url_handicapper; ?>" target="_blank" rel="noreferrer">Buy with points</a>
                                </div>
                            </div>
                           
                        </div>
                    </div>
                </section>
                <?php 
                $day_results = maybe_unserialize(get_post_meta(get_the_ID(), 'day_results', true));

                $show_section = false;

                if (isset($day_results['lastSevenDays']) && $day_results['lastSevenDays'] >= 0) {
                    $show_section = true;
                }

                if (isset($day_results['lastThirtyDays']) && $day_results['lastThirtyDays'] >= 0) {
                    $show_section = true;
                }

                if ($show_section): ?>
                    <section class="handicapper-profits grid-container container">
                        <div class="handicapper-wrapper handicapper-profit-wrapper">
                            <?php if (isset($day_results['lastSevenDays']) && $day_results['lastSevenDays'] >= 0): ?>
                                <div class="profit">
                                    <p>Last 7 days</p>
                                    <p class="profit--accent">$<?php echo esc_html($day_results['lastSevenDays']); ?></p>
                                </div>
                            <?php endif; ?>

                            <?php if (isset($day_results['lastThirtyDays']) && $day_results['lastThirtyDays'] >= 0): ?>
                                <div class="profit">
                                    <p>Last 30 days</p>
                                    <p class="profit--accent">$<?php echo esc_html($day_results['lastThirtyDays']); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </section>
                <?php endif; ?>

                <?php if (is_array($today_picks) && count($today_picks) > 0): ?>
                <section class="handicapper-today-picks grid-container container">
                    <div class="handicapper-wrapper handicapper-today-picks-wrapper">
                        <p class="shh-entry-sub-title">Today's sports picks</p>
                        <div class="shh-card-container">
                            <?php foreach ($today_picks as $key => $today_pick): ?>
                                <div class="shh-card">
                                    <div class="shh-card-row">
                                        <div class="shh-align-left shh-item-text"><?php echo esc_html($today_pick['sport_name']); ?></div>
                                        <div class="shh-align-center shh-item-text"><?php echo esc_html($today_pick['game_date']); ?></div>
                                    </div>

                                    <?php
                                        if ($today_pick['home_id'] != $today_pick['visitor_id']) {
                                            include('parts/teams.php');
                                        } else {
                                            include('parts/tournaments.php');
                                        }
                                    ?>

                        <?php if (isset($today_pick['status']) && $today_pick['status'] != "PRIVATE PICK") { ?>
                            <div class="shh-card-footer">
                                <div class="shh-item-text shh-bordered">
                                    <b>Pending:</b> <?php echo esc_html($today_pick['description']); ?>
                                </div>
                                <div class="shh-item-text">
                                    Release date: <?php echo esc_html($today_pick['game_date']); ?>
                                </div>
                            </div>
                        <?php } else { ?>
                            <div class="shh-card-footer">
                                <div class="shh-item-text shh-item-text--no-free">
                                    Subscribe to our top handicapper today and gain access to all the insider details you can't miss.
                                </div>
                                <div class="shh-pick-btn-wrapper">
                                    <a href="https://members.sportshub.com/register" rel="noreferrer nofollow" target="_blank" class="shh-pick-btn">GET THIS PICK
                                    </a>
                                </div>
                                
                            </div>
                        <?php } ?>
                        </div>
                            <?php 
                        
                        endforeach; 
                        
                        ?>
                        </div>
                    </div>
                </section>
                <?php endif; ?> 
                <div class="shh-content"><?php the_content();?></div>
            </article><!-- .post -->
            <?php
        }
    } 
?>
</main>
<?php get_footer(); ?>
