<?php
/**
 * Template Name: Handicapper
 * Post Type: Handicapper
 */

get_header();

?>

<main id="site-content" role="main">

    <?php
    if (have_posts()) {

        $lapse = [
            'yesterday' => 'Yesterday',
            'lastthreeDays' => 'Last 3 Days',
            'lastSevenDays' => 'Last 7 Days',
            'lastThirtyDays' => 'Last 30 Days',
        ];

        $sports = [
            '1' => 'MLB',
            '2' => 'MAT',
            '3' => 'NBA',
            '4' => 'NFL',
            '5' => 'NHL',
            '6' => 'SOC',
            '7' => 'TOU',
            '8' => 'CBB',
            '9' => 'CFF',
            '10' => 'RBT'
        ];

        while (have_posts()) {
            the_post();
            ?>

            <article class="type-handicapper" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <h1 class="shh-entry-title">
                    <?php the_title(); ?>
                </h1>

                <div class="shh-flex-container">
                    <div class="shh-flex-item-1">
                        <img class="shh-photo" src="<?php echo get_post_meta(get_the_ID(), 'image_url', true); ?>" alt="handicapper_image">
                    </div>
                    <div class="shh-flex-item">
                        <?php the_content(); ?>
                    </div>
                    <div class="shh-flex-item-3">
                        <div class="shh-flex-container">
                            <div class="shh-flex-rank shh-rank-container">
                                <div class="shh-row">
                                    Results
                                </div>
                                <!-- Day Results -->

                                <?php $day_results = maybe_unserialize(get_post_meta(get_the_ID(), 'day_results', true)); ?>
                                <?php foreach ($day_results as $key => $value): ?>
                                    <div class="shh-row shh-rank-result">
                                        <div><?php echo $lapse[esc_html($key)]; ?></div>
                                        <div class='shh-featured'>$ <?php echo esc_html($value); ?></div>
                                    </div>
                                <?php endforeach; ?>

                                <div class="shh-row">
                                    <div>ALL STATS</div>
                                </div>
                            </div>
                            <div class="shh-flex-rank shh-rank-container">
                                <div class="shh-row">
                                    SPORTS RANK
                                </div>
                                <!-- Sports Ranks -->
                                <?php $sports_ranks = maybe_unserialize(get_post_meta(get_the_ID(), 'sports_ranks', true)); ?>
                                <?php foreach ($sports_ranks as $sports_rank): ?>
                                    <div class="shh-row shh-rank-result">
                                        <div><?php echo $sports[esc_html($sports_rank['sportId'])]; ?></div>
                                        <div class='shh-featured'><?php echo esc_html($sports_rank['rank']); ?></div>
                                    </div>
                                <?php endforeach; ?>
                                
                                <div class="shh-row">
                                    <div>&nbsp;</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php $today_picks = maybe_unserialize(get_post_meta(get_the_ID(), 'today_picks', true)); ?>
                
                <?php if (is_array($today_picks) && count($today_picks) > 0): ?>
                <div class="shh-today-picks-section">
                    <h1 class="shh-entry-sub-title">
                        TODAY'S SPORTS PICKS
                    </h1>

                    <!-- TodaysPicks TODO: PICKS STYLE -->
                    <?php
                        $i = 0;
                        $today_picks_images = maybe_unserialize(get_post_meta(get_the_ID(), 'today_picks_images', true));
                        $today_picks_images = (array) $today_picks_images;

                        $picks = [];
                        foreach ($today_picks_images as $subArray) {
                            foreach ($subArray as $key => $value) {
                                $picks[$key] = $value;
                            }
                        }
                    ?>

                    <div class="shh-card-container">
                        <?php foreach ($today_picks as $key => $today_pick): ?>
                            <?php if (is_array($today_picks_images) && count($today_picks_images) > 0): ?>
                                <div class="shh-card">
                                    <div class="shh-card-row">
                                        <div class="shh-align-left shh-item-text"><?php echo esc_html($today_pick['sport_name']); ?></div>
                                        <div class="shh-align-center shh-item-text"><?php echo esc_html($today_pick['game_date']); ?></div>
                                    </div>
                                    <div class="shh-card-row shh-teams">
                                    <div class="shh-team-container">
                                        <?php if (isset($picks[$today_pick['home_id']])): ?>
                                            <img class="shh-align-left ssh-team-img" src="<?php echo $picks[$today_pick['home_id']]; ?>" />
                                        <?php endif; ?>
                                        <div class='shh-featured'><?php echo esc_html($today_pick['home_name']); ?></div>
                                    </div>
                                    <div class="shh-align-center shh-vs">vs</div>
                                    <div class="shh-team-container">
                                    <?php if (isset($picks[$today_pick['visitor_id']])): ?>
                                            <img class="shh-align-right ssh-team-img" src="<?php echo $picks[$today_pick['visitor_id']]; ?>" />
                                        <?php endif; ?>
                                        <div class='shh-featured'><?php echo esc_html($today_pick['visitor_name']); ?></div>
                                    </div>
                                    </div>
                                    <div class="shh-item-text shh-bordered">Pending: <?php echo esc_html($today_pick['description']); ?></div>
                                    <div class="shh-item-text">Release date: <?php echo esc_html($today_pick['game_date']); ?></div>
                                </div>
                            <?php $i++; ?>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>
            </article><!-- .post -->
            <?php
        }
    } 
    ?>

</main>
<?php get_footer(); ?>
