<?php
/**
 * SH Handicappers
 *
 * @package       SHHANDICAP
 * @author        IT
 * @version       1.0.9
 *
 * @wordpress-plugin
 * Plugin Name:   SH Handicappers
 * Plugin URI:    https://www.sportshub.com
 * Description:   SportsHub Handicappers 
 * Version:       1.0.9
 * Author:        IT
 * Author URI:    https://www.sportshub.com
 * Text Domain:   sh-handicappers
 * Domain Path:   /languages
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/**
 * HELPER COMMENT START
 * 
 * This file contains the main information about the plugin.
 * It is used to register all components necessary to run the plugin.
 * 
 * The comment above contains all information about the plugin 
 * that are used by WordPress to differenciate the plugin and register it properly.
 * It also contains further PHPDocs parameter for a better documentation
 * 
 * The function SHHANDICAP() is the main function that you will be able to 
 * use throughout your plugin to extend the logic. Further information
 * about that is available within the sub classes.
 * 
 * HELPER COMMENT END
 */

// Plugin name
define('SHHANDICAP_NAME', 'SH Handicappers');
define('SHHANDICAP_NAME_SLUG', 'sh-handicappers');

// Plugin version
define('SHHANDICAP_VERSION', '1.0.9');

// REDIS
define('REDIS_GROUP_SHHANDICAP', 'sh_handicappers');

if (!defined('SHHANDICAP_REDIS_TIMEOUT')) {
    define('SHHANDICAP_REDIS_TIMEOUT', 3600);
}

// UPLOAD DIR
$plugin_upload_dir = wp_upload_dir()['basedir'] . '/' . str_replace(' ', '_', SHHANDICAP_NAME);
define('SHHANDICAP_PLUGIN_LOG_DIR', $plugin_upload_dir);

// Plugin Root File
define('SHHANDICAP_PLUGIN_FILE', __FILE__);

// Plugin base
define('SHHANDICAP_PLUGIN_BASE', plugin_basename(SHHANDICAP_PLUGIN_FILE));

// Plugin Folder Path
define('SHHANDICAP_PLUGIN_DIR', plugin_dir_path(SHHANDICAP_PLUGIN_FILE));

// Plugin Folder URL
define('SHHANDICAP_PLUGIN_URL', plugin_dir_url(SHHANDICAP_PLUGIN_FILE));

/**
 * Load the main class for the core functionality
 */
require_once SHHANDICAP_PLUGIN_DIR . 'core/class-sh-handicappers.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  IT
 * @since   1.0.0
 * @return  object|Sh_Handicappers
 */
function SHHANDICAP() {
    $shh = Sh_Handicappers::instance();

    return $shh;
}

$shh = SHHANDICAP();