<?php
/**
 * Template Name: Handicapper
 * Post Type: Handicapper
 */

get_header();

?>

<main id="site-content" role="main" class="handicapper-main">

    <?php
        if (have_posts()) {
            $lapse = [
                'yesterday' => 'Yesterday',
                'lastthreeDays' => 'Last 3 Days',
                'lastSevenDays' => 'Last 7 Days',
                'lastThirtyDays' => 'Last 30 Days',
            ];

        while (have_posts()) {
            the_post();
    ?>

            <article class="type-handicapper" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                <h1 class="shh-title"><?php the_title(); ?></h1>
                <div class="shh-container">
                    <div class="shh-photo">
                        <?php $capper_image = (!empty(get_the_post_thumbnail_url())) ? get_the_post_thumbnail_url() : null; ?>

                        <?php if (!empty($capper_image)): ?>
                        <img class="" src="<?php echo $capper_image; ?>" alt="handicapper_image">
                        <?php endif; ?>
                    </div>
                    <div class="shh-body">
                        <div class="shh-description">
                            <?php
                                echo get_post_meta(get_the_ID(), 'handicapper_bio', true);
                            ?>
                        </div>
                        <div class="shh-stats">
                            <div class="shh-stat">
                                <header><span>RESULTS</span></header>
                                <!-- Day Results -->
                                <div class="shh-items">
                                    <?php $day_results = maybe_unserialize(get_post_meta(get_the_ID(), 'day_results', true)); ?>
                                    <?php foreach ($day_results as $key => $value): ?>
                                        <div class="shh-stat-item">
                                            <div class="shh-days"><?php echo $lapse[esc_html($key)]; ?></div>
                                            <div class='shh-featured'>$ <?php echo esc_html($value); ?></div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>

                                <footer><span>ALL STATS</span></footer>
                            </div>
                            <div class="shh-stat">
                                <header><span>SPORTS RANK</span></header>
                                <!-- Sports Ranks -->
                                <div class="shh-items">
                                    <?php $sports_ranks = maybe_unserialize(get_post_meta(get_the_ID(), 'sports_ranks', true)); ?>
                                    <?php foreach ($sports_ranks as $sports_rank): ?>
                                        <div class="shh-stat-item">
                                            <div class="shh-sports"><?php echo esc_html($sports_rank['sport']); ?></div>
                                            <div class='shh-featured'><?php echo esc_html($sports_rank['rank']); ?></div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                <footer><span>&nbsp;</span></footer>
                            </div>
                        </div>
                    </div>
                </div>

                <?php $today_picks = maybe_unserialize(get_post_meta(get_the_ID(), 'today_picks', true)); ?>
                
                <?php if (is_array($today_picks) && count($today_picks) > 0): ?>
                    <div class="shh-today-picks-section">
                        <div class="container content grid-container">
                            <h1 class="shh-entry-sub-title"><span>TODAY'S SPORTS PICKS</span></h1>
                            <div class="shh-card-container">
                                <?php foreach ($today_picks as $key => $today_pick): ?>
                                    <div class="shh-card">
                                        <div class="shh-card-row">
                                            <div class="shh-align-left shh-item-text"><?php echo esc_html($today_pick['sport_name']); ?></div>
                                            <div class="shh-align-center shh-item-text"><?php echo esc_html($today_pick['game_date']); ?></div>
                                        </div>
                                        <div class="shh-card-row shh-teams">
                                        <div class="shh-team-container">
                                            <?php if (isset($today_pick['home_url'])): ?>
                                                <img class="shh-align-left ssh-team-img" src="<?php echo $today_pick['home_url']; ?>" />
                                            <?php endif; ?>
                                            <div class='shh-featured'><?php echo esc_html($today_pick['home_name']); ?></div>
                                        </div>
                                        <div class="shh-align-center shh-vs">vs</div>
                                        <div class="shh-team-container">
                                        <?php if (isset($today_pick['visitor_url'])): ?>
                                                <img class="shh-align-right ssh-team-img" src="<?php echo $today_pick['visitor_url']; ?>" />
                                            <?php endif; ?>
                                            <div class='shh-featured'><?php echo esc_html($today_pick['visitor_name']); ?></div>
                                        </div>
                                        </div>
                                        <div class="shh-card-footer">
                                            <div class="shh-item-text shh-bordered"><b>Pending:</b> <?php echo esc_html($today_pick['description']); ?></div>
                                            <div class="shh-item-text">Release date: <?php echo esc_html($today_pick['game_date']); ?></div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <div class="shh-content"><?php the_content();?></div>
            </article><!-- .post -->
            <?php
        }
    } 
    ?>

</main>
<?php get_footer(); ?>
