<?php
/**
 * SH Handicappers
 *
 * @package       SHHANDICAP
 * @author        IT
 * @version       1.0.0
 *
 * @wordpress-plugin
 * Plugin Name:   SH Handicappers
 * Plugin URI:    https://www.sportshub.com
 * Description:   SportsHub Handicappers 
 * Version:       1.0.0
 * Author:        IT
 * Author URI:    https://www.sportshub.com
 * Text Domain:   sh-handicappers
 * Domain Path:   /languages
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/**
 * HELPER COMMENT START
 * 
 * This file contains the main information about the plugin.
 * It is used to register all components necessary to run the plugin.
 * 
 * The comment above contains all information about the plugin 
 * that are used by WordPress to differenciate the plugin and register it properly.
 * It also contains further PHPDocs parameter for a better documentation
 * 
 * The function SHHANDICAP() is the main function that you will be able to 
 * use throughout your plugin to extend the logic. Further information
 * about that is available within the sub classes.
 * 
 * HELPER COMMENT END
 */

// Plugin name
define('SHHANDICAP_NAME', 'SH Handicappers');

// Plugin version
define('SHHANDICAP_VERSION', '1.0.0');

// Plugin Root File
define('SHHANDICAP_PLUGIN_FILE', __FILE__);

// Plugin base
define('SHHANDICAP_PLUGIN_BASE', plugin_basename(SHHANDICAP_PLUGIN_FILE));

// Plugin Folder Path
define('SHHANDICAP_PLUGIN_DIR', plugin_dir_path(SHHANDICAP_PLUGIN_FILE));

// Plugin Folder URL
define('SHHANDICAP_PLUGIN_URL', plugin_dir_url(SHHANDICAP_PLUGIN_FILE));

/**
 * Load the main class for the core functionality
 */
require_once SHHANDICAP_PLUGIN_DIR . 'core/class-sh-handicappers.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  IT
 * @since   1.0.0
 * @return  object|Sh_Handicappers
 */
function SHHANDICAP() {
    return Sh_Handicappers::instance();
}

SHHANDICAP();
