<?php

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

/**
 * HELPER COMMENT START
 * 
 * This class contains all of the available CLI commands for your plugin. 
 * Down below, we added a command that allows you to display the current 
 * details about your plugin within the console. 
 * 
 * To test the command, please head over to your WordPress instance and type in the following
 * 
 * wp sh_handicappers details
 * 
 * HELPER COMMENT END
 */

WP_CLI::add_command('sh_handicappers', 'Sh_Handicappers_CLI');

/**
 * Class Sh_Handicappers_CLI
 *
 * This class contains all WP CLI related features.
 *
 * @package		SHHANDICAP
 * @subpackage	Classes/Sh_Handicappers_CLI
 * @author		IT
 * @since		1.0.0
 */
class Sh_Handicappers_CLI extends WP_CLI_Command {

    /**
     * Our Sh_Handicappers_CLI constructor 
     * to run the plugin CLI logic.
     *
     * @since 1.0.0
     */
    function __construct(){
    }

    /**
     * Get plugin details
     *
     * ## OPTIONS
     *
     * None. Returns basic info regarding the plugin instance.
     *
     * ## EXAMPLES
     *
     * To access this feature, type the following into your console:
     * wp sh_handicappers details
     *
     * @param		array $args
     * @param		array $assoc_args
     * @return		void
     */
    public function details($args, $assoc_args) {
        WP_CLI::line(sprintf(__('Plugin name: %s', 'SH Handicappers'), SHHANDICAP_NAME));
        WP_CLI::line(sprintf(__('Plugin version: %s', 'SH Handicappers'), SHHANDICAP_VERSION));
    }
    
}
