<?php
//css enqueue
function form_styles($hook){
    wp_enqueue_style('formstyle', plugins_url('formstyle.css', __FILE__));
};


//function save inputs on database
function save_data_db(){
    global $wpdb;
    $max_width = $_POST['maxWidth'];
    $max_height = $_POST['maxHeight'];
    $max_weight = $_POST['maxWeight'];
    $type = (array) $_POST['Type'];

    if (!empty($type)) {
        $type = array_map('trim', $type);
        $type = array_map(function($t){
            return 'image/' . $t;
        }, $type);
        $type = implode(',', $type);
    } else {
        $type = '';
    }

    update_option('maxWidth', $max_width);
    update_option('maxHeight', $max_height);
    update_option('maxWeight', $max_weight);
    update_option('type', $type);

    echo "<div><h2>The information was successfully saved in the database.</h2></div>";

};



//function type
function images_type_limit($file){
    $allowed_types = get_option('type');

    if (empty($allowed_types)){
        $allowed_types = ['image/jpeg', 'image/webp', 'image/png', 'image/avif'];
    } else {
        $allowed_types = explode(',', $allowed_types);
    }

    $allowed_types_string = implode(', ', $allowed_types);

    if (!in_array($file['type'], $allowed_types)) {
        $file['error'] = 'The file type is not allowed. Please use: ' . $allowed_types_string . ' formats';
    }
    return $file;
}
add_filter('wp_handle_upload_prefilter', 'images_type_limit');



//function weigth
function image_weight_limit($file) {
    $max_weight = get_option('maxWeight');
    if (empty($max_weight)){
        $max_weight = 100;
    }

    $max_weight_bytes = $max_weight * 1024;

    if ($file['size'] > $max_weight_bytes) {
        $file['error'] = 'The image is too heavy. It must be maximum ' . $max_weight . ' KB.';
    }
    return $file;
}
add_filter('wp_handle_upload_prefilter', 'image_weight_limit');




//function size
function images_size_limit($file) {
    $max_width = get_option('maxWidth', 1024);
    $max_height = get_option('maxHeight', 800);

    list($width, $height) = getimagesize($file['tmp_name']);

    if ($width > $max_width || $height > $max_height) {
        $file['error'] = 'The image is too large. It must be of maximum size ' . $max_width . 'x' . $max_height . ' pixeles.';
    }

    return $file;
}
add_filter('wp_handle_upload_prefilter', 'images_size_limit');

?>