<?php
if(!defined('ABSPATH')) die();
global $wpdb;

if(isset($_POST['btn-save'])){
    save_data_db();
};

$max_width = get_option('maxWidth');
$max_height = get_option('maxHeight');
$max_weight = get_option('maxWeight');
$allowed_types_without_prefix = str_replace('image/', ' ', get_option('type'));

echo "
<div class='sh-image-restriction-generalMain'>
    <h1>Sh image restrictions</h1>
</div>"
;

echo "
<div class='sh-image-restriction-container'>

        <div class='sh-image-restriction-infocontainer'>
            <h2>Values in database</h2>
            <hr>
            <div class='sh-image-restriction-blockSection'>
                    <h3>Image size:</h3>
                    <p>Max width: " . $max_width . " px </p>
                    <p>Max height: " . $max_height . " px </p>
            </div>
            <div class='sh-image-restriction-blockSection'>
                    <h3>Image weight:</h3>
                    <p>Max weight: " . $max_weight . " kb </p>
            </div>
            <div class='sh-image-restriction-blockSection'>
                    <h3>Image formats:</h3>
                    <p>Allowed formats: <br>" . $allowed_types_without_prefix . " </p>
            </div>
        </div>

        <div class='sh-image-restriction-formcontainer'>
            <form method='POST'>
                    <h2>Enter the values​​ to configure restriction</h2>
                    <hr>
                    <br>
                    <div class='sh-image-restriction-blockSection'>
                        <div class='sh-image-restriction-header'>
                                <h2>Image size</h2>
                                <p>Use pixels as a unit of measurement</p>
                        </div>

                        <div class='sh-image-restriction-item'>
                            <input type='number' name='maxWidth' min='1' required pattern='\d+' value='$max_width' placeholder='Max width on database: " . $max_width . " px' autofocus>
                        
                            <input type='number' name='maxHeight' min='1' required pattern='\d+' value='$max_height' placeholder='Max height on database: " . $max_height . " px'>
                        </div>
                    </div>


                    <div class='sh-image-restriction-blockSection'>
                        <div class='sh-image-restriction-header'>
                            <h2>Image weight</h2>
                            <p>Use KB as a unit of measurement, maximum weight 100 kb</p>
                        </div>
                        <div class='sh-image-restriction-item'>
                            <input type='number' name='maxWeight' min='1' required pattern='\d+' value='$max_weight' placeholder='Max weight on database: " . $max_weight . " kb'>
                        </div>
                    </div>

                    

                    <div class='sh-image-restriction-blockSection'>
                        <div class='sh-image-restriction-header'>
                            <h2>Image format</h2>
                            <p>You can select multiple options with the Ctrl or Shift key</p>
                        </div>
                        <div class='sh-image-restriction-item'>
                            <select name='Type[]' style='width: 150px;' required multiple>
                                <option value='webp' selected>webp</option>
                                <option value='png' selected>png</option>
                                <option value='jpeg' selected>jpeg</option>
                                <option value='avif' selected>avif</option>
                            </select>
                            <p>Allowed formats on database: <br>" . $allowed_types_without_prefix . " </p>
                        </div>
                    </div>
                    
                    <div class='sh-image-restriction-bottomSection'>
                        <input class='sh-image-restriction-btnSend' type='submit' name='btn-save' value='Save on database'>
                    </div>
            </form>
        </div>
    
</div>"; 
?>