<?php
/**
 * SH Mapping 
 *
 * @package       SHMAPPING
 * @author        IT
 * @version       1.0.3
 *
 * @wordpress-plugin
 * Plugin Name:   SH Mapping 
 * Plugin URI:    https://www.sportshub.com
 * Description:   Sports Hub Mapping Plugin
 * Version:       1.0.3
 * Author:        IT
 * Author URI:    https://www.sportshub.com
 * Text Domain:   sh-mapping
 * Domain Path:   /languages
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/**
 * HELPER COMMENT START
 * 
 * This file contains the main information about the plugin.
 * It is used to register all components necessary to run the plugin.
 * 
 * The comment above contains all information about the plugin 
 * that are used by WordPress to differenciate the plugin and register it properly.
 * It also contains further PHPDocs parameter for a better documentation
 * 
 * The function SHMAPPING() is the main function that you will be able to 
 * use throughout your plugin to extend the logic. Further information
 * about that is available within the sub classes.
 * 
 * HELPER COMMENT END
 */

// Plugin name
define('SHMAPPING_NAME', 'SH Mapping');
define('SHMAPPING_NAME_SLUG', 'sh-mapping');

// Plugin version
define('SHMAPPING_VERSION', '1.0.3');

// Plugin Root File
define('SHMAPPING_PLUGIN_FILE', __FILE__);

// Plugin base
define('SHMAPPING_PLUGIN_BASE', plugin_basename(SHMAPPING_PLUGIN_FILE));

// Plugin Folder Path
define('SHMAPPING_PLUGIN_DIR', plugin_dir_path(SHMAPPING_PLUGIN_FILE));

// Plugin Folder URL
define('SHMAPPING_PLUGIN_URL', plugin_dir_url(SHMAPPING_PLUGIN_FILE));

// UPLOAD DIR
$plugin_upload_dir = wp_upload_dir()['basedir'] . '/' . str_replace(' ', '_', SHMAPPING_NAME);
define('SHMAPPING_PLUGIN_LOG_DIR', $plugin_upload_dir);

// REDIS
define('REDIS_GROUP_SHMAPPING', 'sh-mapping');
define('REDIS_KEY_SHMAPPING', 'sh_mapping_data');

if (!defined('SHMAPPING_REDIS_TIMEOUT')) {
    define('SHMAPPING_REDIS_TIMEOUT', 3600);
}

/**
 * Load the main class for the core functionality
 */
require_once SHMAPPING_PLUGIN_DIR . 'core/class-sh-mapping.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  IT
 * @since   1.0.0
 * @return  object|Sh_Mapping
 */
function SHMAPPING() {
    return Sh_Mapping::instance();
}

$shmapping = SHMAPPING();

if (!function_exists('shMappingSportsLeaguesOption')) {
    function shMappingSportsLeaguesOption() {
        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();
        $shmapping->helpers->setRedisGroup(REDIS_GROUP_SHMAPPING);

        $unserialize_data = [];

        if ($shmapping->helpers->initRedis()) {
            $key = $shmapping->helpers->getRedisKeySportsLeaguesOptions();
            $data_sports = $shmapping->helpers->getRedis($key);

            if (!empty($data_sports)) {
                $unserialize_data = unserialize($data_sports);

                if (is_array($unserialize_data) && count($unserialize_data) > 0) {
                    return $unserialize_data;
                }
            }
        }

        try {
            $helpers = New Sh_Mapping_Helpers;
            $sports_mapped = $helpers->getMappingData();
            $sports_leagues_options = $helpers->getSports($sports_mapped);

            return $sports_leagues_options;
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
                'sports_mapped' => $sports_mapped,
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingSportsLeaguesTitles')) {
    function shMappingSportsLeaguesTitles() {
        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();
        $shmapping->helpers->setRedisGroup(REDIS_GROUP_SHMAPPING);

        $unserialize_data = [];

        if ($shmapping->helpers->initRedis()) {
            $key = $shmapping->helpers->getRedisKeySportsLeaguesTitles();
            $data_sports = $shmapping->helpers->getRedis($key);

            if (!empty($data_sports)) {
                $unserialize_data = unserialize($data_sports);

                if (is_array($unserialize_data) && count($unserialize_data) > 0) {
                    return $unserialize_data;
                }
            }
        }

        try {
            $helpers = New Sh_Mapping_Helpers;
            $sports_mapped = $helpers->getMappingData();
            $sports_leagues_titles = $helpers->getSportsTitles($sports_mapped);

            return $sports_leagues_titles;
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
                'sports_mapped' => $sports_mapped,
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingSportsConverter')) {
    function shMappingSportsConverter($sports, $source, $type = 'string') {
        $sports_convert = [];
        $sports_mapped = [];

        try {
            $helpers = New Sh_Mapping_Helpers;
            $sports_mapped = $helpers->getMappingData();

            if (is_array($sports) && count($sports) > 0) {
                foreach ($sports as $sport_id => $leagues) {
                    if (
                        isset($sports_mapped[$sport_id]) &&
                        is_array($sports_mapped[$sport_id]) &&
                        count($sports_mapped[$sport_id]) > 0 &&
                        isset($sports_mapped[$sport_id]['sports'][$source]) &&
                        is_array($sports_mapped[$sport_id]['sports'][$source]) &&
                        count($sports_mapped[$sport_id]['sports'][$source]) > 0
                    ) {
                        $sports_news = [];
                        $leagues_news = [];
                        $sports_news = $sports_mapped[$sport_id]['sports'][$source];

                        if (is_array($leagues) && count($leagues) > 0) {
                            foreach ($leagues as $league_id) {
                                if (
                                    isset($sports_mapped[$sport_id]['leagues'][$league_id][$source]) &&
                                    is_array($sports_mapped[$sport_id]['leagues'][$league_id][$source]) &&
                                    count($sports_mapped[$sport_id]['leagues'][$league_id][$source]) > 0
                                ) {
                                    $leagues_news = array_merge($leagues_news, $sports_mapped[$sport_id]['leagues'][$league_id][$source]);
                                }
                            }
                        }

                        if (isset($sports_convert['sports'])) {
                            $sports_convert['sports'] = array_merge($sports_convert['sports'], $sports_news);
                        } else {
                            $sports_convert['sports'] = $sports_news;
                        }

                        if (isset($sports_convert['leagues'])) {
                            $sports_convert['leagues'] = array_merge($sports_convert['leagues'], $leagues_news);
                        } else {
                            $sports_convert['leagues'] = $leagues_news;
                        }
                    }
                }
            }

            if ($type == 'string') {
                $new_array_ids = '';
                foreach ($sports_convert as $type => $ids) {
                    $new_array_ids .= implode(',', $ids);
                    $new_array_ids .= ',';
                }

                $sports_convert = rtrim($new_array_ids, ',');

                return $sports_convert;
            } else {
                return $sports_convert;
            }

        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
                'sports' => $sports,
                'type' => $type,
                'source' => $source,
                'sports_convert' => $sports_convert,
                'sports_mapped' => $sports_mapped,
            ], true));
        }

        return [];
    }
}
