<?php

// Exit if accessed directly
if (!defined('ABSPATH')) exit;

/**
 * HELPER COMMENT START
 * 
 * This class contains all of the available CLI commands for your plugin. 
 * Down below, we added a command that allows you to display the current 
 * details about your plugin within the console. 
 * 
 * To test the command, please head over to your WordPress instance and type in the following
 * 
 * wp sh_mapping details
 * 
 * HELPER COMMENT END
 */

WP_CLI::add_command('sh_mapping', 'Sh_Mapping_CLI');

/**
 * Class Sh_Mapping_CLI
 *
 * This class contains all WP CLI related features.
 *
 * @package        SHMAPPING
 * @subpackage    Classes/Sh_Mapping_CLI
 * @author        IT
 * @since        1.0.0
 */
class Sh_Mapping_CLI extends WP_CLI_Command {

    /**
     * Our Sh_Mapping_CLI constructor 
     * to run the plugin CLI logic.
     *
     * @since 1.0.0
     */
    function __construct() {
    }


    /**
     * Get plugin details
     *
     * ## OPTIONS
     *
     * None. Returns basic info regarding the plugin instance.
     *
     * ## EXAMPLES
     *
     * To access this feature, type the following into your console:
     * wp sh_mapping details
     *
     * @param array $args
     * @param array $assoc_args
     * @return void
     */
    public function details($args, $assoc_args) {
        WP_CLI::line(sprintf(__('Plugin name: %s', 'SH Mapping'), SHMAPPING_NAME));
        WP_CLI::line(sprintf(__('Plugin version: %s', 'SH Mapping'), SHMAPPING_VERSION));
    }

    public function pull($args, $assoc_args) {
        if (get_option('sh_mapping_status') != 1) {
            error_log(sprintf(__('SH Mapping: Plugin disabled.', 'sh-mapping')));
            WP_CLI::line(sprintf(__('SH Mapping: Plugin disabled.', 'sh-mapping')));

            return;
        }

        $helpers = New Sh_Mapping_Helpers;
        $helpers->delMappingData();
        $sports_mapped = $helpers->getMappingData();

        if (!is_array($sports_mapped) || count($sports_mapped) == 0) {
            error_log(print_r([
                'message' => sprintf(__('SH Mapping: Error while trying to recover the Sports Mapping.', 'sh-mapping')),
                'sports_mapped' => $sports_mapped
            ], true));

            WP_CLI::line(sprintf(__('SH Mapping: Error while trying to recover the Sports Mapping.', 'sh-mapping')));

            return;
        }

        $sports_leagues_options = $helpers->getSports($sports_mapped);
        $sports_leagues_titles = $helpers->getSportsTitles($sports_mapped);

        update_option('sh_mapping_last_run', date('Y-m-d H:i:s'));
    }
}
