<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/**
 * Class Sh_Mapping_Run
 *
 * Thats where we bring the plugin to life
 *
 * @package        SHMAPPING
 * @subpackage    Classes/Sh_Mapping_Run
 * @author        IT
 * @since        1.0.0
 */

class Sh_Mapping_Run {

    /**
     * Our Sh_Mapping_Run constructor 
     * to run the plugin logic.
     *
     * @since 1.0.0
     */
    function __construct() {
        $this->add_hooks();
    }

    /**
     * ######################
     * ###
     * #### WORDPRESS HOOKS
     * ###
     * ######################
     */

    /**
     * Registers all WordPress and plugin related hooks
     *
     * @access    private
     * @since    1.0.0
     * @return    void
     */
    private function add_hooks() {
        add_action('acf/init', [$this, 'generate_form_sh_mapping'], 20);
        add_action('acf/save_post', [$this, 'save_settings_sh_mapping'], 20);
        add_filter('acf/load_value/name=sh_mapping_reset_last_run', [$this, 'load_field_sh_mapping_reset_last_run'], 10, 3);
        add_action('sh_mapping_cron_event', [$this, 'sh_mapping_cron_function']);
        add_filter('cron_schedules', [$this,'sh_mapping_add_cron_interval']);
        
        add_action('admin_enqueue_scripts', [$this, 'enqueue_backend_scripts_and_styles'], 20);
        add_action('admin_menu', [$this, 'register_custom_admin_menu_pages'], 20);
        register_activation_hook(SHMAPPING_PLUGIN_FILE, [$this, 'activation_hook_callback']);
        register_deactivation_hook(SHMAPPING_PLUGIN_FILE, [$this, 'deactivation_hook_callback']);
    }

    public function load_field_sh_mapping_reset_last_run($value) {
        if ($value == 'reset') {
            update_field('sh_mapping_reset_last_run', 'default');
        }

        return 'default';
    }

    public function sh_mapping_cron_function() {
        // Call the WP-CLI command
        $command = 'wp sh_mapping pull';
        $output = shell_exec($command);
    }

    public function activation_hook_callback() {
        if (!wp_next_scheduled('sh_mapping_cron_event')) {
            wp_schedule_event(time(), 'daily', 'sh_mapping_cron_event');
            update_option('sh_mapping_cron_time', 'daily');
        }
    }

    public function deactivation_hook_callback() {
        wp_clear_scheduled_hook('sh_mapping_cron_event');
    }

    public function sh_mapping_add_cron_interval($schedules) {
        if (!array_key_exists("hourly", $schedules)) {
            $schedules['hourly'] = array(
                'interval' => 60 * 60,
                'display'  => __('Every Hour'),
            );
        }

        if (!array_key_exists("twicedaily", $schedules)) {
            $schedules['twicedaily'] = array(
                'interval' => 60 * 60 * 12,
                'display'  => __('Every 12 hours'),
            );
        }

        if (!array_key_exists("daily", $schedules)) {
            $schedules['daily'] = array(
                'interval' => 60 * 60 * 24,
                'display'  => __('Every Day'),
            );
        }

        if (!array_key_exists("weekly", $schedules)) {
            $schedules['weekly'] = array(
                'interval' => 60 * 60 * 24 * 7,
                'display'  => __('Once Weekly'),
            );
        }

        return $schedules;
    }

    public function enqueue_backend_scripts_and_styles() {
        wp_enqueue_style('shmapping-backend-styles', SHMAPPING_PLUGIN_URL . 'core/includes/assets/css/backend-styles.css', array(), SHMAPPING_VERSION, 'all');
    }

    public function register_custom_admin_menu_pages() {
        acf_add_options_page([
            'page_title'    => __('SH Mapping'),
            'menu_title'    => __('SH Mapping'),
            'menu_slug'     => SHMAPPING_NAME_SLUG,
            'capability'    => 'edit_posts',
            'icon_url'      => 'dashicons-networking',
            'redirect'      => true,
        ]);

        acf_add_options_page([
            'page_title'  => __('Settings'),
            'menu_title'  => __('SH Mapping Settings'),
            'parent_slug' => SHMAPPING_NAME_SLUG,
        ]);
    }

    public function generate_form_sh_mapping() {
        if(function_exists('acf_add_local_field_group')):
            acf_add_local_field_group(array(
                'key' => 'group_6g76687gwwerewr682_mapping',
                'title' => 'Sports Hub Mapping Settings',
                'fields' => array(
                    array(
                        'key' => 'field_64d565794ac4f_mapping',
                        'label' => 'Status',
                        'name' => 'sh_mapping_status',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '35',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'inactive' => 'Inactive',
                            'active' => 'Active',
                        ),
                        'default_value' => 'inactive',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                    array(
                        'key' => 'shm_field_646e9a1f84fe1_mapping',
                        'label' => 'Cronjob run time',
                        'name' => 'sh_mapping_cron_time',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d565794ac4f_mapping',
                                    'operator' => '==',
                                    'value' => 'active',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '35',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'hourly' => 'Once Hourly',
                            'twicedaily' => 'Twice Daily',
                            'daily' => 'Once Daily',
                            'weekly' => 'Once Weekly',
                        ),
                        'default_value' => 'daily',
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_64c95bea5809b_mapping',
                        'label' => 'Last Mapping Pull Datetime',
                        'name' => 'sh_mapping_last_run_message',
                        'aria-label' => '',
                        'type' => 'message',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d565794ac4f_mapping',
                                    'operator' => '==',
                                    'value' => 'active',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '30',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => get_option('sh_mapping_last_run', 'never'),
                        'new_lines' => 'wpautop',
                        'esc_html' => 0,
                    ),
                    array(
                        'key' => 'field_6e4tg34t4th34tf34t43_mapping',
                        'label' => 'URL Data',
                        'name' => 'sh_mapping_url',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d565794ac4f_mapping',
                                    'operator' => '==',
                                    'value' => 'active',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6e4sfdssrwrdrwr_mapping',
                        'label' => 'URL Seasons',
                        'name' => 'sh_mapping_url_seasons',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d565794ac4f_mapping',
                                    'operator' => '==',
                                    'value' => 'active',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6drter6534dr34r32dr_mapping',
                        'label' => 'URL Sports',
                        'name' => 'sh_mapping_url_sports',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d565794ac4f_mapping',
                                    'operator' => '==',
                                    'value' => 'active',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_6dqwd34tk986wr3eqsgrfdr_mapping',
                        'label' => 'URL Leagues',
                        'name' => 'sh_mapping_url_leagues',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d565794ac4f_mapping',
                                    'operator' => '==',
                                    'value' => 'active',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'shm_field_64c3e7748071d_mapping',
                        'label' => 'Token',
                        'name' => 'sh_mapping_token',
                        'aria-label' => '',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_64d565794ac4f_mapping',
                                    'operator' => '==',
                                    'value' => 'active',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'maxlength' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'shg_field_646ec0e1bb72a_mapping',
                        'label' => 'Reset Last Run',
                        'name' => 'sh_mapping_reset_last_run',
                        'aria-label' => '',
                        'type' => 'radio',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'default' => 'Default',
                            'reset' => 'Reset',
                        ),
                        'default_value' => '',
                        'return_format' => 'value',
                        'allow_null' => 0,
                        'other_choice' => 0,
                        'layout' => 'horizontal',
                        'save_other_choice' => 0,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-sh-mapping-settings',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));

            acf_add_local_field_group(array(
                'key' => 'group_6g7fewffwefwf_mapping',
                'title' => 'Sports Hub Mapping Cache',
                'fields' => array(
                    array(
                        'key' => 'shg_field_64wefwfwfef1',
                        'label' => 'Sports / Leagues',
                        'name' => 'sh_mapping_sports_leagues',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '100',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => '',
                        'choices' => shMappingSportsLeaguesOption(),
                        'default_value' => 1,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'shg_field_64wrtyhyuy5445ft345t',
                        'label' => 'Sports / Leagues Titles',
                        'name' => 'sh_mapping_sports_leagues_titles',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '100',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => '',
                        'choices' => shMappingSportsLeaguesTitles(),
                        'default_value' => 1,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'sh_mapping_sports_direct',
                        'label' => 'Sports Direct',
                        'name' => 'sh_mapping_sports_direct',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '100',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => '',
                        'choices' => shMappingSportsDirect(),
                        'default_value' => 1,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'shg_field_ghfe45gd5yth4ef5tujessdrffgds',
                        'label' => 'Leagues Direct',
                        'name' => 'sh_mapping_leagues_direct',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '100',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => '',
                        'choices' => shMappingLeaguesSportsDirect('/sport/basketball'),
                        'default_value' => 1,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'shg_field_gsf352hgf3r4gfd56e4gr4r3w',
                        'label' => 'Seasons Direct',
                        'name' => 'sh_mapping_seasons_direct',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '100',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => '',
                        'choices' => shMappingSeasonsDirect('/sport/basketball/league:403878'),
                        'default_value' => 1,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'shg_field_ghje4fdgfhrty5wresrdg',
                        'label' => 'Teams Direct',
                        'name' => 'sh_mapping_teams_direct',
                        'aria-label' => '',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '100',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => '',
                        'choices' => shMappingTeamsLeagueDirect('/sport/basketball/league:403878'),
                        'default_value' => 1,
                        'return_format' => 'value',
                        'multiple' => 0,
                        'allow_null' => 0,
                        'ui' => 0,
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'options_page',
                            'operator' => '==',
                            'value' => 'acf-options-sh-mapping-settings',
                        ),
                    ),
                ),
                'menu_order' => 1,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
                'show_in_rest' => 0,
            ));

            endif;    
    }

    public function save_settings_sh_mapping() {
        try {
            $option = (isset($_GET['page'])) ? $_GET['page'] : null;

            if (!empty($option) && $option == 'acf-options-sh-mapping-settings' && isset($_POST['acf']) && is_array($_POST['acf']) && count($_POST['acf']) > 0) {
                try {
                    $status = current($_POST['acf']);
                    $cron = next($_POST['acf']);
                    $url = next($_POST['acf']);
                    $url_season = next($_POST['acf']);
                    $url_sports = next($_POST['acf']);
                    $url_leagues = next($_POST['acf']);
                    $token = next($_POST['acf']);
                    $reset = next($_POST['acf']);

                    $set_option_status = (!empty($status) && $status == 'active') ? true : false;
                    update_option('sh_mapping_status', $set_option_status, true);

                    $original_cron = get_option('sh_mapping_cron_time');

                    if ((!empty($cron)) && ($original_cron != $cron)) {
                        wp_clear_scheduled_hook('sh_mapping_cron_event');
                        wp_schedule_event(time(), $cron, 'sh_mapping_cron_event');
                        update_option('sh_mapping_cron_time', $cron);
                    }

                    if (!empty($reset) && $reset == 'reset') {
                        delete_option('sh_mapping_last_run');
                        $helpers = New Sh_Mapping_Helpers;
                        $helpers->delMappingData();
                        $helpers->getMappingDataSports();
                    }
                } catch (\Exception $exception) {
                    error_log(print_r([
                        'message' => $exception->getMessage(),
                    ], true));
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => $exception->getMessage(),
                'option' => $option,
            ], true));
        }
    }
}
