# RDG Corp / SH Mapping Plugin for WordPress

Tags: sh mapping, sh, mapping
Requires at least: 6.0
Tested up to: 6.0
Requires PHP: 8.1
Stable tag: 1.0.41
License: GPLv3 or later
License URI: http://www.gnu.org/licenses/gpl-3.0.html

# Changelog
-   1.0.41 (2025-11-25)
    * DEV-932-sh-mapping-verify-and-correct-response-structure-in-sh-mapping-service
        - Fix TypeError
-   1.0.40 (2025-11-24)
    * DEV-932-sh-mapping-verify-and-correct-response-structure-in-sh-mapping-service
        - Fix TypeError in getMappingData() and related functions
        - Add support for both JSON and PHP serialize formats
        - Maintain backward compatibility with old cached data
        - Add error logging for corrupted cache data
        - Resolves production error in sh-games when calling shMappingSportsLeaguesNamesConverter()
        Affected functions:
        - getMappingData()
        - getMappingDataHandicappers()
        - getMappingMembershipsData()
        - getMappingDataSeasons()
        - getMappingDataSports()
        - getMappingDataLeagues()
-   1.0.39 (2025-11-23)
    * DEV-932-sh-mapping-verify-and-correct-response-structure-in-sh-mapping-service
        - Verified and corrected response structure consistency in sh-mapping service
        - Ensures proper data format validation for API responses
        - Improved error handling for malformed response structures
-   1.0.37 (2025-10-27)
    * DEV-853-sh-mapping-fix-hierarchy-mapping-return-second-level-id-instead-of-league-id
        - Fixed clearHierarchy() to return level 2 group ID instead of league ID
        - Changed from using $league_data['id'] (league ID, e.g., 3548) to $league['id'] (group ID, e.g., 269)
        - Ensures correct hierarchy parameters in API requests for RDG blocks
        - Example: Baseball > KBO now correctly returns L269 instead of L3548
        - Impact: All blocks using shMappingHierarchyFamily() now receive correct IDs

-   1.0.36 (2025-10-24)
    * DEV-846-sh-mapping-fix-clearHierarchy-id-league-array-structure
        - Fixed "Undefined array key 'id'" error in clearHierarchy() function (line 690)
        - API changed structure: id_league is now an array of league objects instead of a single object
        - Updated league processing to iterate over id_league array correctly
        - Maintains backward compatibility by checking if id_league is an array before processing
        - Prevents future errors if API returns multiple leagues per group

-   1.0.35 (2025-10-23)
    * DEV-845-sh-mapping-fix-hierarchy-duplicates
        - Fixed duplicate entries in shMappingHierarchyFamily() when groups have both items and leagues with same names
        - Modified navigateArrayRecursively() to prioritize leagues over items to avoid duplicates
        - Affected sports: Golf, Boxing, Tennis, and others with direct leagues
        - Example: Golf now shows 4 options instead of 8 duplicated ones

-   1.0.34 (2025-10-25)
    * DEV-844-sh-mapping-fix-web-request-timeouts
        - CRITICAL: Prevent API calls from web requests to avoid 30s timeouts
        - Added protection to getMappingMembershipsData(), getMappingDataHierarchy(), and getMappingDataHandicappers()
        - Web requests now only use cached data (Redis/file cache)
        - Only WP-CLI commands can make fresh API calls
        - Respects emergency mode for additional safety
-   1.0.33 (2025-10-25)
    * DEV-844-sh-mapping-fix-order-hierarchies-function
        - Fixed infinite recursion in orderHierarchies() caused by API structure change
        - Added cycle detection to prevent circular reference loops
        - Optimized hierarchy building with O(1) lookup indexing
        - Normalized null values for consistent parent-child comparisons
-   1.0.32 (2025-10-20)
    * DEV-833-add-bp-to-label-in-some-sporst-hierarchy-options
        - Added sufix
-   1.0.31 (2025-10-06)
    * DEV-809-sas-prevent-displaying-debugging-errors-in-sh-mapping
        - fix: resolve empty select fields in settings page
-   1.0.30 (2025-10-06)
    * DEV-809-sas-prevent-displaying-debugging-errors-in-sh-mapping
        - Make ACF cache fields non-required when empty
-   1.0.29 (2025-10-04)
    * DEV-809-sas-prevent-displaying-debugging-errors-in-sh-mapping
        - Prevents massive requests
-   1.0.28 (2025-10-02)
    * DEV-809-sas-prevent-displaying-debugging-errors-in-sh-mapping
        - Prevents debugging output in browser, enhanced request timeout
-   1.0.27 (2025-08-14)
    * DEV-741-improve-api-error-messages-and-add-token-configuration-diagnostics
        - Prevents malformed API requests with empty keys 
-   1.0.26 (2025-07-31)
    * DEV-693-migrate-cache-to-redis
        - New function to get sports from api hierarchy.
-   1.0.25 (2025-07-14)
    * DEV-721-add-goal-serve-ids
        - New handicapper IDs were mapped to key members.
-   1.0.24 (2025-04-28)
    * DEV-607-multiple-ctp-in-sh-game-plugin
        - Function shMappingHierarchyConverterSingle is implemented.
-   1.0.23 (2025-04-15)
    * DEV-607-multiple-ctp-in-sh-game-plugin
        - Function shMappingSportsLeaguesConverterSingle is implemented.
-   1.0.22 (2025-04-05)
    * DEV-611-picks-vs-multiple-selection
        - Implemented features to retrieve sports and categories from leaderboard.
-   1.0.21 (2025-04-02)
    * DEV-583-leaderboard-block-update
        - Method shMappingGetMembershipsLogic was included, It is responsible for showing the logic of the packages in memberships.
-   1.0.20 (2025-03-11)
    * DEV-559-change-on-handicappers-profile
        - Method shMappingMemberships was included, which is responsible for listing memberships with their packages.
        - Method shMappingMembershipsHandicappers was included, which is responsible for listing memberships equivalent to a specific membership.
        - The shopping Memberships Data method was included, responsible for obtaining the data for the plan presentation logic.
-   1.0.19 (2025-01-27)
    * DEV-482-handicappers-ranking-block
        - Function shMappingHandicappers is implemented.
-   1.0.18 (2024-11-21)
    * DEV-467-fix-request-in-mapping
        - Token obtaining has been updated.
-   1.0.17 (2024-09-20)
    * DEV-431-load-players-cli-command
        - pull_players command was created to load all players.
-   1.0.16 (2024-09-06)
    * DEV-322-expert-betting-guide
        - Hierarchy IDs are updated to identify the type of filter to apply.
-   1.0.15 (2024-08-13)
    * DEV-342-create-injury-report-block
        - Implementation of hierarchy sports is completed.
        - Implementation of hierarchy family is completed.
-   1.0.14 (2024-08-07)
    * DEV-342-create-injury-report-block
        - Implementation of hierarchy leagues is completed.
-   1.0.13 (2024-07-12)
    * DEV-342-create-injury-report-block
        - Serialization format changed to json.
-   1.0.12 (2024-06-26)
    * DEV-342-create-injury-report-block
        - Update load players data.
-   1.0.11 (2024-06-24)
    * DEV-342-create-injury-report-block
        - Created function shMappingTeamPlayers.
-   1.0.10 (2024-05-07)
    * DEV-247-top-cappers-change
        - Created function shMappingSportsOnly.
-   1.0.9 (2024-03-19)
    * DEV-175-sh-mapping-plugin-main-update
        - Created function shMappingSportsLeaguesNamesConverter.
-   1.0.8 (2024-03-05)
    * DEV-175-sh-mapping-plugin-main-update
        - Versions for simple and complete sh game are integrated.
-   1.0.7 (2024-02-16)
    * DEV-175-sh-mapping-plugin-main-update
        - The shMappingSportsLeaguesConverter method was created.
-   1.0.6 (2024-02-16)
    * DEV-175-sh-mapping-plugin-main-update
        - The shMappingSportsHierarchyConverter method was deleted.
        - The shMappingAuthorsMainsSportsLeaguesConverter method was created.
-   1.0.5 (2024-02-02)
    * DEV-175-sh-mapping-plugin-main-update
        - The shMappingSportsHierarchyConverter method was created.
-   1.0.4 (2023-10-31)
    * DEV-175-sh-mapping-plugin-development
        - Fixed response format in arrays.
-   1.0.3 (2023-10-28)
    * DEV-175-sh-mapping-plugin-development
        - The id string is repaired.
-   1.0.2 (2023-10-28)
    * DEV-175-sh-mapping-plugin-development
        - ID response format updated.
-   1.0.1 (2023-10-24)
    * DEV-175-sh-mapping-plugin-development
        - The shMappingSportsLeaguesOption, shMappingSportsLeaguesTitles and shMappingSportsConverter methods were implemented.
