<?php
/**
 * SH Mapping 
 *
 * @package       SHMAPPING
 * @author        IT
 * @version       1.0.18
 *
 * @wordpress-plugin
 * Plugin Name:   SH Mapping 
 * Plugin URI:    https://www.sportshub.com
 * Description:   Sports Hub Mapping Plugin
 * Version:       1.0.18
 * Author:        IT
 * Author URI:    https://www.sportshub.com
 * Text Domain:   sh-mapping
 * Domain Path:   /languages
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/**
 * HELPER COMMENT START
 * 
 * This file contains the main information about the plugin.
 * It is used to register all components necessary to run the plugin.
 * 
 * The comment above contains all information about the plugin 
 * that are used by WordPress to differenciate the plugin and register it properly.
 * It also contains further PHPDocs parameter for a better documentation
 * 
 * The function SHMAPPING() is the main function that you will be able to 
 * use throughout your plugin to extend the logic. Further information
 * about that is available within the sub classes.
 * 
 * HELPER COMMENT END
 */

// Plugin name
define('SHMAPPING_NAME', 'SH Mapping');
define('SHMAPPING_NAME_SLUG', 'sh-mapping');

// Plugin version
define('SHMAPPING_VERSION', '1.0.18');

// Plugin Root File
define('SHMAPPING_PLUGIN_FILE', __FILE__);

// Plugin base
define('SHMAPPING_PLUGIN_BASE', plugin_basename(SHMAPPING_PLUGIN_FILE));

// Plugin Folder Path
define('SHMAPPING_PLUGIN_DIR', plugin_dir_path(SHMAPPING_PLUGIN_FILE));

// Plugin Folder URL
define('SHMAPPING_PLUGIN_URL', plugin_dir_url(SHMAPPING_PLUGIN_FILE));

// UPLOAD DIR
$plugin_upload_dir = wp_upload_dir()['basedir'] . '/' . str_replace(' ', '_', SHMAPPING_NAME);
define('SHMAPPING_PLUGIN_LOG_DIR', $plugin_upload_dir);

// REDIS
define('REDIS_GROUP_SHMAPPING', 'sh-mapping');
define('REDIS_KEY_SHMAPPING', 'sh_mapping_data');

if (!defined('SHMAPPING_REDIS_TIMEOUT')) {
    define('SHMAPPING_REDIS_TIMEOUT', 3600);
}

/**
 * Load the main class for the core functionality
 */
require_once SHMAPPING_PLUGIN_DIR . 'core/class-sh-mapping.php';

/**
 * The main function to load the only instance
 * of our master class.
 *
 * @author  IT
 * @since   1.0.0
 * @return  object|Sh_Mapping
 */
function SHMAPPING() {
    return Sh_Mapping::instance();
}

$shmapping = SHMAPPING();

if (!function_exists('shMappingSportsLeaguesOption')) {
    function shMappingSportsLeaguesOption() {
        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();
        $shmapping->helpers->setRedisGroup(REDIS_GROUP_SHMAPPING);

        $unserialize_data = [];

        if ($shmapping->helpers->initRedis()) {
            $key = $shmapping->helpers->getRedisKeySportsLeaguesOptions();
            $data_sports = $shmapping->helpers->getRedis($key);

            if (!empty($data_sports)) {
                $unserialize_data = unserialize($data_sports);

                if (is_array($unserialize_data) && count($unserialize_data) > 0) {
                    return $unserialize_data;
                }
            }
        }

        try {
            $file_path_sports = SHMAPPING_PLUGIN_LOG_DIR.'/'.$shmapping->helpers->getFileNameSportsOptions();

            if (file_exists($file_path_sports)) {
                $sports = file_get_contents($file_path_sports);

                if (!empty($sports) && is_array(unserialize($sports))) {
                    return unserialize($sports);
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        try {
            $helpers = New Sh_Mapping_Helpers;
            $sports_mapped = $helpers->getMappingData();
            $sports_leagues_options = $helpers->getSports($sports_mapped);

            return $sports_leagues_options;
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
                'sports_mapped' => $sports_mapped,
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingSportsOnly')) {
    function shMappingSportsOnly() {
        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();
        $shmapping->helpers->setRedisGroup(REDIS_GROUP_SHMAPPING);

        $unserialize_data = [];

        if ($shmapping->helpers->initRedis()) {
            $key = $shmapping->helpers->getRedisKeySportsOnly();
            $data_sports = $shmapping->helpers->getRedis($key);

            if (!empty($data_sports)) {
                $unserialize_data = unserialize($data_sports);

                if (is_array($unserialize_data) && count($unserialize_data) > 0) {
                    return $unserialize_data;
                }
            }
        }

        try {
            $file_path_sports = SHMAPPING_PLUGIN_LOG_DIR.'/'.$shmapping->helpers->getFileNameSportsOnly();

            if (file_exists($file_path_sports)) {
                $sports = file_get_contents($file_path_sports);

                if (!empty($sports) && is_array(unserialize($sports))) {
                    return unserialize($sports);
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        try {
            $helpers = New Sh_Mapping_Helpers;
            $sports_mapped = $helpers->getMappingData();
            $sports_only = $helpers->getSportsOnly($sports_mapped);

            return $sports_only;
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
                'sports_mapped' => $sports_mapped,
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingSportsLeaguesTitles')) {
    function shMappingSportsLeaguesTitles() {
        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();
        $shmapping->helpers->setRedisGroup(REDIS_GROUP_SHMAPPING);

        $unserialize_data = [];

        if ($shmapping->helpers->initRedis()) {
            $key = $shmapping->helpers->getRedisKeySportsLeaguesTitles();
            $data_sports = $shmapping->helpers->getRedis($key);

            if (!empty($data_sports)) {
                $unserialize_data = unserialize($data_sports);

                if (is_array($unserialize_data) && count($unserialize_data) > 0) {
                    return $unserialize_data;
                }
            }
        }

        try {
            $file_path_titles = SHMAPPING_PLUGIN_LOG_DIR.'/'.$shmapping->helpers->getFileNameTitles();

            if (file_exists($file_path_titles)) {
                $titles = file_get_contents($file_path_titles);

                if (!empty($titles) && is_array(unserialize($titles))) {
                    return unserialize($titles);
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        try {
            $helpers = New Sh_Mapping_Helpers;
            $sports_mapped = $helpers->getMappingData();
            $sports_leagues_titles = $helpers->getSportsTitles($sports_mapped);

            return $sports_leagues_titles;
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
                'sports_mapped' => $sports_mapped,
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingSportsConverter')) {
    function shMappingSportsConverter($sports, $source, $type = 'string') {
        $sports_convert = [];
        $sports_mapped = [];

        try {
            $helpers = New Sh_Mapping_Helpers;
            $sports_mapped = $helpers->getMappingData();

            if (is_array($sports) && count($sports) > 0) {
                foreach ($sports as $sport_id => $leagues) {
                    if (
                        isset($sports_mapped[$sport_id]) &&
                        is_array($sports_mapped[$sport_id]) &&
                        count($sports_mapped[$sport_id]) > 0 &&
                        isset($sports_mapped[$sport_id]['sports'][$source]) &&
                        is_array($sports_mapped[$sport_id]['sports'][$source]) &&
                        count($sports_mapped[$sport_id]['sports'][$source]) > 0
                    ) {
                        $sports_news = [];
                        $leagues_news = [];
                        $sports_news = $sports_mapped[$sport_id]['sports'][$source];

                        if (is_array($leagues) && count($leagues) > 0) {
                            foreach ($leagues as $league_id) {
                                if (
                                    isset($sports_mapped[$sport_id]['leagues'][$league_id][$source]) &&
                                    is_array($sports_mapped[$sport_id]['leagues'][$league_id][$source]) &&
                                    count($sports_mapped[$sport_id]['leagues'][$league_id][$source]) > 0
                                ) {
                                    $leagues_news = array_merge($leagues_news, $sports_mapped[$sport_id]['leagues'][$league_id][$source]);
                                }
                            }
                        }

                        foreach ($sports_news as $new_sport_id) {
                            if (isset($sports_convert[$new_sport_id])) {
                                $sports_convert[$new_sport_id] = array_merge($sports_convert[$new_sport_id], $leagues_news);
                            } else {
                                $sports_convert[$new_sport_id] = $leagues_news;
                            }
                        }
                    }
                }
            }

            if ($type == 'string') {
                $new_array_ids = [];
                foreach ($sports_convert as $sport_id => $league_ids) {
                    if (is_array($league_ids) && count($league_ids) == 0) {
                        array_push($new_array_ids, $sport_id);
                        continue;
                    }

                    foreach ($league_ids as $league_key => $league_id) {
                        array_push($new_array_ids, $league_id);
                    }
                }

                return implode(',', array_unique($new_array_ids));
            } else {
                return $sports_convert;
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
                'sports' => $sports,
                'type' => $type,
                'source' => $source,
                'sports_convert' => $sports_convert,
                'sports_mapped' => $sports_mapped,
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingLeaguesDirect')) {
    function shMappingLeaguesDirect() {
        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();
        $shmapping->helpers->setRedisGroup(REDIS_GROUP_SHMAPPING);

        $unserialize_data = [];

        if ($shmapping->helpers->initRedis()) {
            $key = $shmapping->helpers->getRedisKeyLeaguesDirect();
            $data_leagues_direct = $shmapping->helpers->getRedis($key);

            if (!empty($data_leagues_direct)) {
                $unserialize_data = unserialize($data_leagues_direct);

                if (is_array($unserialize_data) && count($unserialize_data) > 0) {
                    return $unserialize_data;
                }
            }
        }

        try {
            $file_path_titles = SHMAPPING_PLUGIN_LOG_DIR.'/'.$shmapping->helpers->getFileNameLeaguesDirect();

            if (file_exists($file_path_titles)) {
                $titles = file_get_contents($file_path_titles);

                if (!empty($titles) && is_array(unserialize($titles))) {
                    return unserialize($titles);
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        try {
            $helpers = New Sh_Mapping_Helpers;
            $sports_mapped = $helpers->getMappingData();
            $sports_teams_direct = $helpers->getSportsLeaguesDirect($sports_mapped);

            return $sports_teams_direct;
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
                'sports_mapped' => $sports_mapped,
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingTeamsDirect')) {
    function shMappingTeamsDirect() {
        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();
        $shmapping->helpers->setRedisGroup(REDIS_GROUP_SHMAPPING);

        $unserialize_data = [];

        if ($shmapping->helpers->initRedis()) {
            $key = $shmapping->helpers->getRedisKeyTeamsDirect();
            $data_teams_direct = $shmapping->helpers->getRedis($key);

            if (!empty($data_teams_direct)) {
                $unserialize_data = unserialize($data_teams_direct);

                if (is_array($unserialize_data) && count($unserialize_data) > 0) {
                    return $unserialize_data;
                }
            }
        }

        try {
            $file_path_titles = SHMAPPING_PLUGIN_LOG_DIR.'/'.$shmapping->helpers->getFileNameTeamsDirect();

            if (file_exists($file_path_titles)) {
                $titles = file_get_contents($file_path_titles);

                if (!empty($titles) && is_array(unserialize($titles))) {
                    return unserialize($titles);
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        try {
            $helpers = New Sh_Mapping_Helpers;
            $sports_mapped = $helpers->getMappingData();
            $sports_teams_direct = $helpers->getSportsTeamsDirect($sports_mapped);

            return $sports_teams_direct;
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
                'sports_mapped' => $sports_mapped,
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingSeasonsDirect')) {
    function shMappingSeasonsDirect($league_id = null) {
        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();
        $shmapping->helpers->setRedisGroup(REDIS_GROUP_SHMAPPING);

        $unserialize_data = [];

        if ($shmapping->helpers->initRedis()) {
            $key = $shmapping->helpers->getRedisKeySeasonsDirect();
            $data_seasons_direct = $shmapping->helpers->getRedis($key);

            if (!empty($data_seasons_direct)) {
                $unserialize_data = unserialize($data_seasons_direct);

                if (is_array($unserialize_data) && count($unserialize_data) > 0) {
                    $seasons = $shmapping->helpers->getSeasonsLeague($unserialize_data, $league_id);

                    if (is_array($seasons) && count($seasons) > 0) {

                        return $seasons;
                    }
                }
            }
        }

        try {
            $file_path_titles = SHMAPPING_PLUGIN_LOG_DIR.'/'.$shmapping->helpers->getFileNameSeasonsDirect();

            if (file_exists($file_path_titles)) {
                $seasons_array = file_get_contents($file_path_titles);

                if (!empty($seasons_array) && is_array(unserialize($seasons_array))) {
                    $seasons = $shmapping->helpers->getSeasonsLeague(unserialize($seasons_array), $league_id);

                    if (is_array($seasons) && count($seasons) > 0) {

                        return $seasons;
                    }
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        try {
            $helpers = New Sh_Mapping_Helpers;
            $sports_mapped = $helpers->getMappingData();
            $sports_seasons_direct = $helpers->getMappingDataSeasons($sports_mapped);
            $seasons = $shmapping->helpers->getSeasonsLeague($sports_seasons_direct, $league_id);

            if (is_array($seasons) && count($seasons) > 0) {

                return $seasons;
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingSportsDirect')) {
    function shMappingSportsDirect() {
        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();
        $shmapping->helpers->setRedisGroup(REDIS_GROUP_SHMAPPING);

        $unserialize_data = [];

        if ($shmapping->helpers->initRedis()) {
            $key = $shmapping->helpers->getRedisKeySportsDirect();
            $data_seasons_direct = $shmapping->helpers->getRedis($key);

            if (!empty($data_seasons_direct)) {
                $unserialize_data = unserialize($data_seasons_direct);

                if (is_array($unserialize_data) && count($unserialize_data) > 0) {
                    return $unserialize_data;
                }
            }
        }

        try {
            $file_path_titles = SHMAPPING_PLUGIN_LOG_DIR.'/'.$shmapping->helpers->getFileNameSportsDirect();

            if (file_exists($file_path_titles)) {
                $titles = file_get_contents($file_path_titles);

                if (!empty($titles) && is_array(unserialize($titles))) {
                    return unserialize($titles);
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        try {
            $helpers = New Sh_Mapping_Helpers;
            $sports_seasons_direct = $helpers->getMappingDataSports();

            return $sports_seasons_direct;
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingLeaguesSportsDirect')) {
    function shMappingLeaguesSportsDirect($sport_id = null) {
        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();
        $shmapping->helpers->setRedisGroup(REDIS_GROUP_SHMAPPING);

        $unserialize_data = [];

        if ($shmapping->helpers->initRedis()) {
            $key = $shmapping->helpers->getRedisKeyLeaguesSportDirect();
            $data_seasons_direct = $shmapping->helpers->getRedis($key);

            if (!empty($data_seasons_direct)) {
                $unserialize_data = unserialize($data_seasons_direct);

                if (is_array($unserialize_data) && count($unserialize_data) > 0) {
                    $leagues = $shmapping->helpers->getLeaguesSport($unserialize_data, $sport_id);

                    if (is_array($leagues) && count($leagues) > 0) {

                        return $leagues;
                    }
                }
            }
        }

        try {
            $file_path_titles = SHMAPPING_PLUGIN_LOG_DIR.'/'.$shmapping->helpers->getFileNameLeaguesSportDirect();

            if (file_exists($file_path_titles)) {
                $leagues_sports = file_get_contents($file_path_titles);

                if (!empty($leagues_sports) && is_array(unserialize($leagues_sports))) {
                    $leagues = $shmapping->helpers->getLeaguesSport(unserialize($leagues_sports), $sport_id);

                    if (is_array($leagues) && count($leagues) > 0) {

                        return $leagues;
                    }
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        try {
            $helpers = New Sh_Mapping_Helpers;
            $leagues_sport_direct = $helpers->getMappingDataLeagues();
            $leagues = $shmapping->helpers->getLeaguesSport($leagues_sport_direct, $sport_id);

            if (is_array($leagues) && count($leagues) > 0) {

                return $leagues;
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingTeamsLeagueDirect')) {
    function shMappingTeamsLeagueDirect($league_id = null) {
        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();
        $shmapping->helpers->setRedisGroup(REDIS_GROUP_SHMAPPING);

        $unserialize_data = [];

        if ($shmapping->helpers->initRedis()) {
            $key = $shmapping->helpers->getRedisKeyTeamsDirect();
            $data_teams_direct = $shmapping->helpers->getRedis($key);

            if (!empty($data_teams_direct)) {
                $unserialize_data = unserialize($data_teams_direct);

                if (is_array($unserialize_data) && count($unserialize_data) > 0) {
                    $teams = $shmapping->helpers->getTeamsLeague($unserialize_data, $league_id);

                    if (is_array($teams) && count($teams) > 0) {

                        return $teams;
                    }
                }
            }
        }

        try {
            $file_path_teams = SHMAPPING_PLUGIN_LOG_DIR.'/'.$shmapping->helpers->getFileNameTeamsDirect();

            if (file_exists($file_path_teams)) {
                $teams_data = file_get_contents($file_path_teams);

                if (!empty($teams_data) && is_array(unserialize($teams_data))) {
                    $teams = $shmapping->helpers->getTeamsLeague(unserialize($teams_data), $league_id);

                    if (is_array($teams) && count($teams) > 0) {

                        return $teams;
                    }
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        try {
            $helpers = New Sh_Mapping_Helpers;
            $sports_mapped = $helpers->getMappingData();
            $sports_teams_direct = $helpers->getSportsTeamsDirect($sports_mapped);
            $teams = $shmapping->helpers->getTeamsLeague($sports_teams_direct, $league_id);

            if (is_array($teams) && count($teams) > 0) {

                return $teams;
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
                'sports_mapped' => $sports_mapped,
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingSportsLeaguesConverter')) {
    function shMappingSportsLeaguesConverter($sports, $source, $type = 'string') {
        $sports_convert = [];
        $leagues_convert = [];
        $sports_mapped = [];

        try {
            $helpers = New Sh_Mapping_Helpers;
            $sports_mapped = $helpers->getMappingData();

            if (is_array($sports) && count($sports) > 0) {
                foreach ($sports as $sport_id => $leagues) {
                    if (isset($sports_mapped[$sport_id]) &&
                        is_array($sports_mapped[$sport_id]) &&
                        count($sports_mapped[$sport_id]) > 0 &&
                        isset($sports_mapped[$sport_id]['sports'][$source]) &&
                        is_array($sports_mapped[$sport_id]['sports'][$source]) &&
                        count($sports_mapped[$sport_id]['sports'][$source]) > 0
                    ) {
                        if (is_array($leagues) && count($leagues) > 0) {
                            foreach ($leagues as $league) {
                                if (isset($sports_mapped[$sport_id]['leagues'][$league][$source]) &&
                                    is_array($sports_mapped[$sport_id]['leagues'][$league][$source]) &&
                                    count($sports_mapped[$sport_id]['leagues'][$league][$source]) > 0
                                ) {
                                    $leagues_convert = array_merge($leagues_convert, $sports_mapped[$sport_id]['leagues'][$league][$source]);
                                }
                            }
                        } else {
                            $sports_convert = array_merge($sports_convert, $sports_mapped[$sport_id]['sports'][$source]);
                        }
                    }
                }

                if ($type == 'string') {
                    return [
                        'sports' => implode(',', $sports_convert),
                        'leagues' => implode(',', $leagues_convert),
                    ];
                } else {
                    return [
                        'sports' => $sports_convert, 
                        'leagues' => $leagues_convert
                    ];
                }
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
                'sports' => $sports,
                'type' => $type,
                'source' => $source,
                'sports_convert' => $sports_convert,
                'leagues_convert' => $leagues_convert,
                'sports_mapped' => $sports_mapped,
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingAuthorsMainsSportsLeaguesConverter')) {
    function shMappingAuthorsMainsSportsLeaguesConverter($data, $type = 'members') {
        $helpers = New Sh_Mapping_Helpers;
        $sports_mapped = $helpers->getMappingData();
        $sports_new = [];
        $leagues_new = [];

        if (is_array($data) && count($data) > 0) {
            foreach ($data as $sport_league => $author) {
                $sport_parts = explode('-', $sport_league);

                if (is_array($sport_parts) && count($sport_parts) == 2) {
                    $leagues = (isset($sports_mapped[$sport_parts[0]]['leagues'][$sport_parts[1]][$type]))
                        ? $sports_mapped[$sport_parts[0]]['leagues'][$sport_parts[1]][$type]
                        : null;
                    
                    if (!empty($leagues) && is_array($leagues) && count($leagues) > 0) {
                        foreach ($leagues as $league) {
                            $leagues_new[$league] = $data[$sport_parts[0].'-'.$sport_parts[1]];
                        }
                    }
                } else {
                    $sports = (isset($sports_mapped[$sport_parts[0]]['sports'][$type]))
                        ? $sports_mapped[$sport_parts[0]]['sports'][$type]
                        : null;

                    if (!empty($sports) && is_array($sports) && count($sports) > 0) {
                        foreach ($sports as $sport) {
                            $sports_new[$sport] = $data[$sport_parts[0]];
                        }
                    }
                }
            }
        }

        return [
            'sports' => $sports_new,
            'leagues' => $leagues_new,
        ];
    }
}

if (!function_exists('shMappingSportsLeaguesNamesConverter')) {
    function shMappingSportsLeaguesNamesConverter($type = 'members') {
        $helpers = New Sh_Mapping_Helpers;
        $sports_mapped = $helpers->getMappingData();
        $sports = [];
        $leagues = [];

        foreach ($sports_mapped as $sport_mapping_id => $sport_data) {
            $sport_name = $sport_data['name'];

            if (isset($sport_data['sports'][$type]) && is_array($sport_data['sports'][$type]) && count($sport_data['sports'][$type]) > 0) {
                foreach ($sport_data['sports'][$type] as $id => $sport_id) {
                    $sports[$sport_id] = $sport_name;
                }
            }

            if (isset($sport_data['leagues']) && is_array($sport_data['leagues']) && count($sport_data['leagues']) > 0) {
                foreach ($sport_data['leagues'] as $id => $league) {
                    $league_name = $league['name'];

                    foreach ($league[$type] as $id => $league_id) {
                        $leagues[$league_id] = $league_name;
                    }
                }
            }
        }

        return [
            'sports' => $sports,
            'leagues' => $leagues,
        ];
    }
}

if (!function_exists('shMappingTeamPlayers')) {
    function shMappingTeamPlayers() {
        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();

        try {
            $players_mapped = $shmapping->helpers->getMappingDataPlayers();

            if (is_array($players_mapped) && count($players_mapped) > 0) {
                return $players_mapped;
            }
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
                'players_mapped' => $players_mapped,
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingHierarchySports')) {
    function shMappingHierarchySports() {
        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();
        $shmapping->helpers->setRedisGroup(REDIS_GROUP_SHMAPPING);

        $unserialize_data = [];
        $key = $shmapping->helpers->getRedisKeyHierarchySports();

        if ($shmapping->helpers->initRedis()) {
            $sports_data = $shmapping->helpers->getRedis($key);
    
            if (!empty($sports_data) && $shmapping->helpers->Isjson($sports_data)) {
                $unserialize_data = json_decode($sports_data, true);
                if (is_array($unserialize_data) && count($unserialize_data) > 0) {
                    return $unserialize_data;
                }
            }
        }

        try {
            $mapped_hierarchy = $shmapping->helpers->getMappingDataHierarchy();

            return $shmapping->helpers->getMappingHierarchySports($mapped_hierarchy);
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        return [];
    }
}

if (!function_exists('shMappingHierarchyFamily')) {
    function shMappingHierarchyFamily($item = null) {
        if (empty($item)) return [];

        global $shmapping;
        $shmapping = (!empty($shmapping)) ? $shmapping : Sh_Mapping::instance();

        try {
            $mapped_hierarchy = $shmapping->helpers->getMappingDataHierarchy();

            return $shmapping->helpers->getMappingHierarchyFilter($mapped_hierarchy, $item);
        } catch (\Exception $exception) {
            error_log(print_r([
                'message' => 'SH Mapping: '.$exception->getMessage(),
            ], true));
        }

        return [];
    }
}
