<?php
    $per_page = block_directory_get_per_page(get_fields());
    $label_link = (!empty(get_field('label_link'))) ? get_field('label_link') : '';
    $title = (!empty(get_field('title'))) ? get_field('title') : '';

    $category_include = (!empty(get_field('category_include'))) ? array_column(get_field('category_include'), 'term_taxonomy_id') : [];
    $category_exclude = (!empty(get_field('category_exclude'))) ? array_column(get_field('category_exclude'), 'term_taxonomy_id') : [];
?>

<div id="wpcr-block-directory" class="<?php echo get_spaces_classes(get_fields()); ?>"></div>

<script type="text/javascript">
    jQuery(document).ready(function($) {
        // This is required for AJAX to work on our page
        var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
        
        function cvf_load_all_posts(page, letter) {
            // Data to receive from our server
            // the value in 'action' is the key that will be identified by the 'wp_ajax_' hook 
            var data = {
                page: page,
                letter: letter,
                title: '<?php echo $title; ?>',
                per_page: <?php echo $per_page; ?>,
                label_link: '<?php echo $label_link; ?>',
                show: '<?php echo get_field('show'); ?>',
                elements_post: '<?php echo (!empty(get_field('elements_post'))) ? serialize(get_field('elements_post')) : ''; ?>',
                select_category_type: '<?php echo (!empty(get_field('select_category_type'))) ? get_field('select_category_type') : ''; ?>',
                category_include: '<?php echo serialize($category_include); ?>',
                category_exclude: '<?php echo serialize($category_exclude); ?>',
                action: "block_directory_list"
            };

            // Send the data
            $.post(ajaxurl, data, function(response) {
                // If successful Append the data into our html container
                $("#wpcr-block-directory").empty().append(response);
            });
        }

        // Load page 1 as the default
        cvf_load_all_posts(1, '');

        // Handle the clicks
        $(document).on("click",".paginator button", function(event) {    
            var page = $(this).attr('p');
            var letter = $(this).attr('l');
            cvf_load_all_posts(page, letter);
        });

        $(document).on("click",".reviews-nav button", function(event) {    
            var letter = $(this).attr('l');
            cvf_load_all_posts(1, letter);
        });
    }); 
</script>
