<?php

namespace WpcrSportsbooksReviewsUtils;

class Wpcr_Sportsbooks_Reviews_Utils
{
    function wpcr_sportsbooks_reviews_webpack($file, $buildDirectory = 'dist')
    {
        static $manifest;
        static $manifestPath;

        if (is_null($manifest) || $manifestPath !== $buildDirectory) {
            $manifest = json_decode(
                file_get_contents(WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . $buildDirectory.'/manifest.json'),
                true
            );

            $manifestPath = $buildDirectory;
        }

        if (isset($manifest[$file])) {
            return WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY_URL .trim($buildDirectory.'/'.$manifest[$file], '/');
        }

        throw new InvalidArgumentException("File {$file} not defined in asset manifest.");
    }

    function wpcr_sportsbooks_reviews_stars ($rating) {
        $rating = (intval($rating) / 2) + 0.5;
        $count = intval($rating);

        for ($i=1; $i <= $count; $i++) { 
            echo '<div class="star star-full"></div>';
        }

        if ($count != $rating) {
            echo '<div class="star star-half"></div>';
            $count += 0.5;
        }

        if ($count < 5) {
            for ($i=1; $i <= (5 - $count) ; $i++) { 
                echo '<div class="star star-empty"></div>';
            }
        }
    }
}