<?php /* Template Name: WPCR Review New */ ?>

<?php get_header(); ?>

<main class="wpcr-template-review-new">
    <div class="reviews-header">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="reviews-breadcrumbs">
                        <?php if (false != get_field('breadcrumbs')): ?>
                            <?php foreach (get_field('breadcrumbs') as $link): ?>
                                <a href="<?php echo $link['link']['url']; ?>" target="<?php echo $link['link']['target']; ?>"><?php echo $link['link']['title']; ?></a>/
                            <?php endforeach; ?>
                            <span><?php the_title(); ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="reviews-title">
                        <h1><?php the_title(); ?></h1>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container">
        <?php
            $content = str_replace('wp-block-columns', 'wpcr-block-columns', apply_filters('the_content', get_the_content()));
            echo str_replace('wp-block-column', 'wpcr-block-column', $content);
        ?>
    </div>
</main>

<?php get_footer(); ?>
