<?php
require_once WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . "includes/class-wpcr-sportsbooks-reviews-utils.php";

class Wpcr_Sportsbooks_Reviews_Block_Custom_Sidebar extends \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils
{
    private $blockName          = 'custom-sidebar';
    private $blockFolderName    = 'custom-sidebar';
    private $blockTitle         = 'Custom Sidebar';
    private $blockDescription   = '';
    private $blockIcon          = 'admin-links';
    private $blockKeywords      = ['wpcr', 'custom', 'sidebar'];
    private $category           = "reviews-blocks";
    private $utils;

    function init() {
        $this->utils = new \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils();
        $this->register_block();
        $this->register_fields();
    }

    function get_block_name() {
        return $this->blockName;
    }

    function register_block() {
        if (function_exists('acf_register_block')) {
            acf_register_block(
                array(
                    'name' => $this->blockName,
                    'title' => __($this->blockTitle),
                    'description' => __($this->blockDescription),
                    'render_template' => WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . 'blocks/'. $this->blockFolderName .'/template.php',
                    'category' => $this->category,
                    'icon' => $this->blockIcon,
                    'keywords' => $this->blockKeywords,
                    'enqueue_style' => $this->utils->wpcr_sportsbooks_reviews_webpack('block_custom_sidebar.css'),
                )
            );
        }
    }

    function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_block_custom_sidebar',
                'title' => 'Block_Sidebar',
                'fields' => array(
                    array(
                        'key' => 'field_block_custom_sidebar_title',
                        'label' => __('Title'),
                        'name' => 'custom_sidebar_title',
                        'type' => 'text',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_block_custom_sidebar_list',
                        'label' => __('Sidebar'),
                        'name' => 'list_sidebar',
                        'type' => 'select',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'choices' => $this->get_sidebar(),
                        'default_value' => false,
                        'allow_null' => 1,
                        'multiple' => 0,
                        'ui' => 0,
                        'return_format' => 'value',
                        'ajax' => 0,
                    ),
                    array(
                        'key' => 'field_block_custom_sidebar_classes',
                        'label' => __('Classes Sidebar'),
                        'name' => 'custom_sidebar_classes',
                        'type' => 'text',
                        'required' => 0,
                    ),
                    array(
                        'key' => 'field_block_custom_sidebar_id',
                        'label' => __('ID Sidebar'),
                        'name' => 'custom_sidebar_id',
                        'type' => 'text',
                        'required' => 0,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/custom-sidebar',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }

    function get_sidebar() {
        global $wp_registered_sidebars;

        return array_column($wp_registered_sidebars, 'name', 'id');
    }
}

$custom_sidebar_class = new Wpcr_Sportsbooks_Reviews_Block_Custom_Sidebar();
$custom_sidebar_class->init();

add_action('wp_enqueue_scripts', 'block_custom_sidebar_scripts');

function block_custom_sidebar_scripts() {
    $custom_sidebar_class = new Wpcr_Sportsbooks_Reviews_Block_Custom_Sidebar();
    $block_name = $custom_sidebar_class->get_block_name();

    $template_dir = get_template_directory();
    $template_uri = get_template_directory_uri();
    $plugin_dir = basename(plugin_dir_path(dirname(__FILE__ , 2)));
    
    $custom_css_base = $plugin_dir.'-templates/block-'.$block_name.'.css';

    if (file_exists($template_dir.'/'.$custom_css_base)) {
        wp_enqueue_style('block-'.$block_name.'-style', $template_uri.'/'.$custom_css_base, [], true);
    }
}