<?php if (!empty($title)): ?>
    <div class="wpcr-block-title">
        <span><?php echo $title; ?></span>
    </div>
<?php endif; ?>

<ul class="reviews-nav">
    <li class="item <?php echo $current_letter === false ? 'active' : '' ?>">
        <button l="*" class="<?php echo empty($current_letter) ? 'selected' : 'active'; ?>" <?php echo empty($current_letter) ? 'disabled' : ''; ?>>All</button>
    </li>
    <?php foreach( $reviews_letters_bar as $letter => $has_content ): ?>
        <?php if ($has_content): ?>
            <li class="item">
                <button l="<?php echo $letter;?>" class="<?php echo $current_letter == $letter ? 'selected' : 'active'; ?>" <?php echo $current_letter == $letter ? 'disabled' : ''; ?>><?php echo $letter; ?></button>
            </li>
        <?php else: ?>
            <li class="item">
                <button l="null" class="inactive" disabled><?php echo $letter; ?></button>
            </li>
        <?php endif; ?>
    <?php endforeach; ?>
    <div class="clear_fix"></div>
</ul>
<ul class="reviews">
    <?php if (count($reviews) == 0): ?>
        No reviews has being made yet!
    <?php else: ?>
        <?php foreach($reviews as $review): ?>
        <?php
            $sportbook_item_permalink = get_post_permalink($review->ID);
            $bonus = false;
            $blocks = parse_blocks($review->post_content);

            foreach ($blocks as $block) {
                if ('core/column' == $block['blockName'] && count($block['innerBlocks']) > 0) {
                    if ('acf/review-header' == $block['innerBlocks'][0]['blockName'] && count($block['innerBlocks'][0]['attrs']['data']) > 0) {
                        $bonus_title = (!empty($block['innerBlocks'][0]['attrs']['data']['bonus_bonus_title'])) ? $block['innerBlocks'][0]['attrs']['data']['bonus_bonus_title'] : 'Bonus';
                        $bonus_content = $block['innerBlocks'][0]['attrs']['data']['bonus_bonus'];
                        $bonus_link = $block['innerBlocks'][0]['attrs']['data']['bonus_link'];
                        $bonus_attributes = $block['innerBlocks'][0]['attrs']['data']['bonus_attributes'];
                        $logo = (!empty($block['innerBlocks'][0]['attrs']['data']['logo'])) ? $block['innerBlocks'][0]['attrs']['data']['logo'] : '';
                        $rating = $block['innerBlocks'][0]['attrs']['data']['rating'];

                        if (!empty($bonus_title) && !empty($bonus_content) && is_array($bonus_link) && isset($bonus_link['url']) && is_int($logo)) {
                            $link_title = (!empty($bonus_link['title'])) ? $bonus_link['title'] : 'Play Now';
                            $link_target = (!empty($bonus_link['target'])) ? $bonus_link['target'] : '_self';
                            $link_attributes = (!empty($bonus_attributes)) ? 'rel="'.implode(', ', $bonus_attributes).'"' : '';
                            $bonus = true;
                        }
                    }

                    break;
                }
            }
        ?>
        <li class="item">
            <?php if ($bonus): ?>
                <div class="thumbnail">
                    <div class="logo">
                        <?php
                            echo wp_get_attachment_image($block['innerBlocks'][0]['attrs']['data']['logo'], 'review-thumb');
                        ?>
                        <div class="rating">
                            <div class="review-item-rating-ins">
                                <div class="review-item-rating-box">
                                    <div class="star-rating">
                                        <?php echo get_rating_stars($rating); ?>                                               
                                    </div>
                                </div>
                            </div>
                            <span><?php echo (intval($rating) / 2) + 0.5; ?></span>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <?php
                if ($bonus) {
                    $size = 'size-description-small';
                } else {
                    $size = 'size-description-full';
                }
            ?>
            <div class="description <?php echo $size; ?>">
                <?php
                    if ($bonus) {
                        $content_size = 'size-small';
                    } else {
                        $content_size = 'size-100';
                    }
                ?>
                <div class="content <?php echo $content_size; ?>">
                    <div class="title">
                        <a href="<?php echo $sportbook_item_permalink ?>"><?php echo $review->post_title ?></a>
                    </div>
                    <div class="excerpt">
                        <?php
                            if (!empty($review->post_excerpt)) {
                                $content = str_replace('[&hellip;]','', $review->post_excerpt);
                            } else {
                                $content = substr(wp_strip_all_tags($review->post_content), 0, 560);
                            }
                        ?>
                        <?php echo $content; ?>
                    </div>
                    <div class="link">
                        <a href="<?php echo $sportbook_item_permalink; ?>"><?php echo $label_link; ?></a>
                    </div>
                </div>

                <?php if($bonus): ?>
                    <div class="bonus">
                        <span class="title"><?php echo $bonus_title; ?></span>
                        <p><?php echo $bonus_content; ?></p>
                        <div class="buttons">
                            <a href="<?php echo $bonus_link['url']; ?>" target="<?php echo $link_target; ?>" <?php echo $link_attributes; ?>><?php echo $link_title; ?></a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="clear_fix"></div>
        </li>
        <?php endforeach; ?>
    <?php endif; ?>
</ul>