<?php
require_once WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . "includes/class-wpcr-sportsbooks-reviews-utils.php";

class Wpcr_Sportsbooks_Reviews_Block_Faq extends \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils
{
    private $blockName          = 'faq';
    private $blockFolderName    = 'faq';
    private $blockTitle         = 'FAQ';
    private $blockDescription   = '';
    private $blockIcon          = 'admin-links';
    private $blockKeywords      = ['wpcr', 'faq', 'custom'];
    private $category           = "reviews-blocks";
    private $utils;

    function init() {
        $this->utils = new \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils();
        $this->register_block();
        $this->register_fields();
    }

    function get_block_name() {
        return $this->blockName;
    }

    function register_block() {
        if (function_exists('acf_register_block')) {
            acf_register_block(
                array(
                    'name' => $this->blockName,
                    'title' => __($this->blockTitle),
                    'description' => __($this->blockDescription),
                    'render_template' => WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . 'blocks/'. $this->blockFolderName .'/template.php',
                    'category' => $this->category,
                    'icon' => $this->blockIcon,
                    'keywords' => $this->blockKeywords,
                    'enqueue_style' => $this->utils->wpcr_sportsbooks_reviews_webpack('block_faq.css'),
                )
            );
        }
    }

    function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_block_faq',
                'title' => 'Block_faq',
                'fields' => array(
                    array(
                        'key' => 'field_block_faq_001',
                        'label' => 'FAQ Page ID',
                        'name' => 'faq-page-id',
                        'type' => 'text',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_block_faq_002',
                        'label' => 'Title',
                        'name' => 'title',
                        'type' => 'text',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_block_faq_003',
                        'label' => 'Description',
                        'name' => 'description',
                        'type' => 'textarea',
                        'required' => 1,
                    ),
                    array(
                        'key' => 'field_block_faq_004',
                        'label' => 'Items',
                        'name' => 'items',
                        'type' => 'repeater',
                        'required' => 1,
                        'min' => 1,
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_block_faq_005',
                                'label' => 'Title',
                                'name' => 'title',
                                'type' => 'text',
                                'required' => 1,
                            ),
                            array(
                                'key' => 'field_block_faq_006',
                                'label' => 'Content',
                                'name' => 'content',
                                'type' => 'wysiwyg',
                                'required' => 1,
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 0,
                                'delay' => 0,
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/faq',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }
}

$faq_class = new Wpcr_Sportsbooks_Reviews_Block_Faq();
$faq_class->init();

add_action('wp_enqueue_scripts', 'block_faq_scripts');

function block_faq_scripts() {
    $faq_class = new Wpcr_Sportsbooks_Reviews_Block_Faq();
    $block_name = $faq_class->get_block_name();

    $template_dir = get_template_directory();
    $template_uri = get_template_directory_uri();
    $plugin_dir = basename(plugin_dir_path(dirname(__FILE__ , 2)));
    
    $custom_css_base = $plugin_dir.'-templates/block-'.$block_name.'.css';

    if (file_exists($template_dir.'/'.$custom_css_base)) {
        wp_enqueue_style($plugin_dir.'-style', $template_uri.'/'.$custom_css_base, [], true);
    }

    wp_enqueue_script('block-'.$block_name.'-script', plugin_dir_url(dirname(__FILE__ , 2)).'blocks/'.$block_name.'/assets/js/block-'.$block_name.'-script.js', array('jquery'), '', false);
}

function block_faq_json($items, $faq_page_id) {
    $json_open = "<script type=\"application/ld+json\">\n{\n\t";
    $json_cose = "\n}\n</script>";

    $header_open = "\"@context\": \"https://schema.org\",\n\t\"@type\": \"FAQPage\",\n\t\"@name\": \"FAQ\",\n\t\"@id\": \"".$faq_page_id."\",\n\t\"mainEntity\": [\n\t\t";
    $items_json = '';

    $i = 1;
    $max = count($items);

    foreach($items as $item) {
        $separate = ($max != $i) ? ",\n\t\t" : "\n\t";
        $items_json .= "{\n\t\t\t\"@type\": \"Question\",\n\t\t\t\"name\": \"".$item['title']."\",\n\t\t\t\"acceptedAnswer\": {\n\t\t\t\t\"@type\": \"Answer\",\n\t\t\t\t\"text\": \"".str_replace("\n", '', strip_tags($item['content']))."\"\n\t\t\t}\t\n\t\t}".$separate;
        $i++;
    }

    $header_close = "]";

    return $json_open.$header_open.$items_json.$header_close.$json_cose;
}
