<?php
$average = array_sum(array_column(get_field('items'), 'rating')) / count(get_field('items'));
?>
<div id="wpcr-block-overall-rating" class="<?php echo get_spaces_classes(get_fields()); ?>">
    <?php if (!empty(get_field('title'))): ?>
        <div class="wpcr-block-title">
            <span><?php echo get_field('title'); ?></span>
        </div>
    <?php endif; ?>
    <div class="row">
        <div class="col-12">
            <div class="review-body">
                <div class="content">
                    <div class="overall-rating">
                        <div class="item-title"><?php echo get_field('overall_title'); ?></div>
                        <div class="item-stars">
                            <div class="review-item-rating-ins">
                                <div class="review-item-rating-box">
                                    <div class="star-rating">
                                        <?php echo get_rating_stars($average); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="item-rating rating-style">
                            <span><?php echo (intval($average) / 2) + 0.5; ?><span>/5</span></span>
                        </div>
                    </div>
                    <div class="items">
                        <?php foreach(get_field('items') as $item): ?>
                            <div class="item">
                                <div class="item-title"><?php echo $item['title']; ?></div>
                                <div class="item-stars">
                                    <div class="review-item-rating-ins">
                                        <div class="review-item-rating-box">
                                            <div class="star-rating">
                                                <?php echo get_rating_stars($item['rating']); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="item-rating rating-style">
                                    <span><?php echo (intval($item['rating']) / 2) + 0.5; ?><span>/5</span></span>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
