<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://www.wpcostarica.com
 * @since      1.0.0
 *
 * @package    Wpcr_Sportsbooks_Reviews
 * @subpackage Wpcr_Sportsbooks_Reviews/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Wpcr_Sportsbooks_Reviews
 * @subpackage Wpcr_Sportsbooks_Reviews/includes
 * @author     WPCR <mario@wpcostarica.com>
 */
class Wpcr_Sportsbooks_Reviews_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'wpcr-sportsbooks-reviews',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
