<?php
require_once WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . "includes/class-wpcr-sportsbooks-reviews-utils.php";

class Wpcr_Sportsbooks_Reviews_Block_Logo_Rating extends \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils
{
    private $blockName          = 'logo-rating';
    private $blockFolderName    = 'logo-rating';
    private $blockTitle         = 'Logo Rating';
    private $blockDescription   = '';
    private $blockIcon          = 'admin-links';
    private $blockKeywords      = ['review', 'logo', 'rating'];
    private $category           = "reviews-blocks";
    private $utils;

    function init() {
        $this->utils = new \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils();
        $this->register_block();
        $this->register_fields();
    }

    function get_block_name() {
        return $this->blockName;
    }

    function register_block() {
        if (function_exists('acf_register_block')) {
            acf_register_block(
                array(
                    'name' => $this->blockName,
                    'title' => __($this->blockTitle),
                    'description' => __($this->blockDescription),
                    'render_template' => WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . 'blocks/'. $this->blockFolderName .'/template.php',
                    'category' => $this->category,
                    'icon' => $this->blockIcon,
                    'keywords' => $this->blockKeywords,
                    'enqueue_style' => $this->utils->wpcr_sportsbooks_reviews_webpack('block_logo_rating.css'),
                )
            );
        }
    }

    function register_fields() {
        if(function_exists('acf_add_local_field_group')):
            acf_add_local_field_group(array(
                'key' => 'group_block_logo_rating',
                'title' => 'Block_Logo_Rating',
                'fields' => array(
                    array(
                        'key' => 'field_block_logo_rating_block_title',
                        'label' => __('Title'),
                        'name' => 'block_title',
                        'type' => 'text',
                        'required' => 0,
                    ),
                    array(
                        'key' => 'field_block_logo_rating_title_title_logo',
                        'label' => __('Title Logo'),
                        'name' => 'title_logo',
                        'type' => 'text',
                        'required' => 0,
                    ),
                    array(
                        'key' => 'field_block_logo_rating_logo',
                        'label' => __('Logo'),
                        'name' => 'logo',
                        'type' => 'image',
                        'required' => 1,
                        'return_format' => 'array',
                        'preview_size' => 'medium',
                        'library' => 'all',
                    ),
                    array(
                        'key' => 'field_block_logo_rating_title_rating',
                        'label' => __('Title Rating'),
                        'name' => 'title_rating',
                        'type' => 'text',
                        'required' => 0,
                    ),
                    array(
                        'key' => 'field_block_logo_rating_rating',
                        'label' => __('Rating'),
                        'type' => 'select',
                        'name' => 'rating',
                        'required' => 1,
                        'choices' => [
                            1 => '1',
                            2 => '1.5',
                            3 => '2',
                            4 => '2.5',
                            5 => '3',
                            6 => '3.5',
                            7 => '4',
                            8 => '4.5',
                            9 => '5',
                        ],
                        'allow_null' => 1,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/logo-rating',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }
}

$logo_rating_class = new Wpcr_Sportsbooks_Reviews_Block_Logo_Rating();
$logo_rating_class->init();

add_action('wp_enqueue_scripts', 'block_logo_rating_scripts');

function block_logo_rating_scripts() {
    $logo_rating_class = new Wpcr_Sportsbooks_Reviews_Block_Logo_Rating();
    $block_name = $logo_rating_class->get_block_name();

    $template_dir = get_template_directory();
    $template_uri = get_template_directory_uri();
    $plugin_dir = basename(plugin_dir_path(dirname(__FILE__ , 2)));
    
    $custom_css_base = $plugin_dir.'-templates/block-'.$block_name.'.css';

    if (file_exists($template_dir.'/'.$custom_css_base)) {
        wp_enqueue_style('block-'.$block_name.'-style', $template_uri.'/'.$custom_css_base, [], true);
    }
}
