<?php
require_once "class-wpcr-sportsbooks-reviews-utils.php";

class Wpcr_Sportsbooks_Reviews_Core extends \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils {
    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the collections used to maintain the actions and filters.
     *
     * @since    1.0.0
     */
    public function __construct( $plugin_name, $version ) {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }

    /**
     * Register the filters and actions with WordPress.
     *
     * @since    1.0.0
     */
    public function run() {

    }

    /**
     * Initialize the core requirements
     *
     * @since 1.0.0
     */
    public function init() {
        $this->register_blocks();
        $this->register_taxonomies();
        $this->register_taxonomy_terms();
        $this->register_post_type();
        $this->register_thumbnail_sizes();
        $this->register_base_style();
    }

    function register_blocks() {
        add_filter('render_block', [$this, 'wpcr_sportsbooks_reviews_rewrite_blocks'], 10, 2);
        add_filter('block_categories_all', [$this, 'wpcr_sportsbooks_reviews_block_category'], 10, 2);

        foreach (glob(WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY  . "blocks/*/main.php") as $block_file) {
            include $block_file;
        }
    }

    function wpcr_sportsbooks_reviews_rewrite_blocks($block_content, $block) {
        if ('core/heading' === $block['blockName']) {
            return '<div class="block-heading">' . $block_content . '</div>';
        }

        return $block_content;
    }

    function wpcr_sportsbooks_reviews_block_category($categories) {
        $categories = array_merge(
            $categories,
            array(
                array(
                    'slug' => 'reviews-blocks',
                    'title' => __('Reviews Blocks', 'reviews-blocks'),
                ),
            )
        );

        return $categories;
    }

    function register_taxonomies() {
        $labels = array(
            'name' => _x('Review Types', 'review types'),
            'singular_name' => _x('Review Type', 'review type'),
            'search_items' => __('Search Types'),
            'all_items' => __('All Types'),
            'parent_item' => null,
            'parent_item_colon' => null,
            'edit_item' => __('Edit Review Type'),
            'update_item' => __('Update Review Type'),
            'add_new_item' => __('Add New Review Type'),
            'new_item_name' => __('New Review Type Name'),
            'menu_name' => __('Review Types'),
        );

        $args = array(
            'labels' => $labels,
            'public'        => true,
            'hierarchical'  => true,
            'show_in_rest'  => true,
            'rewrite'       => true,
            'query_var'     => true,
        );

        register_taxonomy('review_type', array('reviews'), $args);
    }

    function register_taxonomy_terms() {
        $terms = array(
            'Sportsbook',
            'Handicapper',
            'Price Per Head',
        );

        foreach ($terms as $term) {
            wp_insert_term($term, 'review_type');
        }
    }

    /**
     * Register the post type "Review"
     *
     * @since 1.0.0
     */
    private function register_post_type() {
        register_post_type(
            'Reviews',
            // CPT Options
            array(
                'labels' => array(
                    'name' => __('Review'),
                    'singular_name' => __('Review'),
                ),
                'supports' => [
                    "title",
                    "editor",
                    "author",
                    "thumbnail",
                    "excerpt",
                    "custom-fields",
                    "revisions",
                    "comments",
                    "page-attributes",
                ],
                'public' => true,
                'has_archive' => true,
                'rewrite' => array('slug' => '/review', 'with_front' => false),
                'show_in_nav_menus' => true,
                'show_in_rest' => true,
                'hierarchical' => true,
                'query_var' => 'review',
                'capability_type' => 'post',
                'template' => [
                    [
                        'core/column',
                        ['className' => 'review-header'],
                        []
                    ],
                    [
                        'core/columns',
                        [],
                        [
                            [
                                'core/column',
                                ['layout' => 50, 'className' => 'review-content'],
                                []
                            ],
                            [
                                'core/column',
                                ['layout' => 50, 'className' => 'review-widget'],
                                []
                            ],
                        ]
                    ],
                ]
            )
        );
    }

    /**
     * Define additional thumbnail sizes
     *
     * @since 1.0.0
     */
    private function register_thumbnail_sizes() {
        add_image_size('review-thumb', 400, 200, false );
    }

    /**
     * Base styles are registered
     *
     * @since 1.0.0
     */
    private function register_base_style() {
        $utils = new \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils();
        $base_style = $utils->wpcr_sportsbooks_reviews_webpack('wpcr_base_style.css');

        wp_enqueue_style('wpcr_base_style', $base_style, [], true);
    }
}
