<div id="wpcr-block-faq" class="<?php echo get_spaces_classes(get_fields()); ?>">
    <div class="row">
        <div class="col-12">
            <?php if (!empty(get_field('title'))): ?>
                <div class="wpcr-block-title">
                    <span><?php echo get_field('title'); ?></span>
                </div>
            <?php endif; ?>
            <div class="content">
                <?php if (!empty(get_field('description'))): ?>
                    <div class="description">
                        <p><?php echo get_field('description'); ?></p>
                    </div>
                <?php endif; ?>
                
                <div id="items">
                    <?php
                        $i = 1;
                        $max = count(get_field('items'));
                        $ID = (!empty(get_field('faq-page-id'))) ? get_field('faq-page-id') : rand(1, 999999);
                    ?>
                    <?php foreach(get_field('items') as $section): ?>
                        <div class="item">
                            <div class="faq-header header" ref="<?php echo $ID;?>" data="<?php echo $max;?>" id="heading<?php echo $ID.$i;?>" data-toggle="collapse" data-target="#collapse<?php echo $ID.$i;?>" aria-expanded="false" aria-controls="collapse<?php echo $ID.$i;?>">
                                <span><?php echo $section['title']; ?></span>
                                <div class="icon">
                                    <i class="fa fa-chevron-down" id="heading<?php echo $ID.$i;?>-down"></i>
                                    <i class="fa fa-chevron-up hide" id="heading<?php echo $ID.$i;?>-up"></i>
                                </div>
                            </div>
                            <div id="collapse<?php echo $ID.$i;?>" class="collapse" aria-labelledby="heading<?php echo $ID.$i;?>" data-parent="#items">
                                <div class="body">
                                    <?php echo $section['content']; ?>
                                </div>
                            </div>
                        </div>
                        <?php $i++; ?>
                    <?php endforeach; ?>
                </div>
            </div>

        </div>
    </div>
</div>

<?php
    echo block_faq_json(get_field('items'), get_field('faq-page-id'));
?>
