<?php
    $rel_tag = '';
    if (!empty(get_field('bonus')['attributes'])) {
        $rel_tag = 'rel="'.implode(' ', get_field('bonus')['attributes']).'"';
    }
?>
<div id="wpcr-block-review-header" class="<?php echo get_spaces_classes(get_fields()); ?>">
    <?php if (!empty(get_field('title'))): ?>
        <div class="wpcr-block-title">
            <span><?php echo get_field('title'); ?></span>
        </div>
    <?php endif; ?>
    <div class="col-sm-12">
        <div class="review-detail">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="content">
                            <div class="review-body">
                                <div class="section logo">
                                    <img src="<?php echo get_field('logo')['url']; ?>" alt="">
                                    <div class="rating">
                                        <div class="review-item-rating-ins">
                                            <div class="review-item-rating-box">
                                                <div class="star-rating">
                                                    <?php echo get_rating_stars(get_field('rating')); ?>
                                                </div>
                                            </div>
                                        </div>
                                        <span><?php echo (intval(get_field('rating')) / 2) + 0.5; ?></span>
                                    </div>
                                </div>
                                <div class="section-one">
                                    <div class="section bonus">
                                        <span class="title"><?php echo (!empty(get_field('bonus')['bonus_title'])) ? get_field('bonus')['bonus_title'] : __('Bonus'); ?></span>
                                        <?php echo get_field('bonus')['bonus']; ?>
                                        <div class="buttons">
                                            <a href="<?php echo get_field('bonus')['link']['url']; ?>" target="<?php echo get_field('bonus')['link']['target']; ?>" <?php echo $rel_tag; ?>><?php echo get_field('bonus')['link']['title']; ?></a>
                                        </div>
                                    </div>
                                    <div class="section products">
                                        <span class="title"><?php echo (!empty(get_field('product')['products_title'])) ? get_field('product')['products_title'] : __('Products'); ?></span>
                                        <div class="content">
                                            <?php
                                                $border_color = (get_field('product')['list_color'] != 'other')
                                                    ? get_field('product')['list_color']
                                                    : get_field('product')['color_picker'];
                                            ?>
                                            <?php echo str_replace('<li>','<li><i class="'.get_field('product')['list_style'].'" style="color: '.$border_color.';"></i>', get_field('product')['list_product']); ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="section-two">
                                    <div class="section deposit">
                                        <span class="title"><?php echo (!empty(get_field('deposit_title'))) ? get_field('deposit_title') : __('Deposit Methods'); ?></span>
                                        <div class="deposit_methods">
                                            <?php foreach(get_field('deposit_methods') as $deposit): ?>
                                                <div class="item">
                                                    <img src="<?php echo $deposit['method']['url']?>" alt="">
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                    <div class="section payout">
                                        <span class="title"><?php echo (!empty(get_field('payout_title'))) ? get_field('payout_title') : __('Payout Methods'); ?></span>
                                        <div class="payout_methods">
                                            <?php foreach(get_field('payout_methods') as $payout): ?>
                                                <div class="item">
                                                    <img src="<?php echo $payout['method']['url']?>" alt="">
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
