<?php
require_once WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . "includes/class-wpcr-sportsbooks-reviews-utils.php";
require_once WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . 'models/class-wpcr-review-entity.php';

class Wpcr_Sportsbooks_Reviews_Block_Directory extends \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils
{
    private $blockName          = 'directory';
    private $blockFolderName    = 'directory';
    private $blockTitle         = 'Review Directory';
    private $blockDescription   = '';
    private $blockIcon          = 'admin-links';
    private $blockKeywords      = ['review', 'directory'];
    private $category           = "reviews-blocks";
    private $utils;

    function init() {
        $this->utils = new \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils();
        $this->register_block();
        $this->register_fields();
    }

    function get_block_name() {
        return $this->blockName;
    }

    function register_block() {
        if (function_exists('acf_register_block')) {
            acf_register_block(
                array(
                    'name' => $this->blockName,
                    'title' => __($this->blockTitle),
                    'description' => __($this->blockDescription),
                    'render_template' => WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . 'blocks/'. $this->blockFolderName .'/template.php',
                    'category' => $this->category,
                    'icon' => $this->blockIcon,
                    'keywords' => $this->blockKeywords,
                    'enqueue_style' => $this->utils->wpcr_sportsbooks_reviews_webpack('block_directory.css'),
                )
            );
        }
    }

    function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_block_directory',
                'title' => 'Block_Directory',
                'fields' => array(
                    array(
                        'key' => 'field_627198e1df7bf',
                        'label' => 'Title',
                        'name' => 'title',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'maxlength' => '',
                    ),
                    array(
                        'key' => 'field_627198efc515c',
                        'label' => 'Label Read Review',
                        'name' => 'label_link',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'maxlength' => '',
                    ),
                    array(
                        'key' => 'field_6271443872873',
                        'label' => 'Row per page',
                        'name' => 'quantity',
                        'type' => 'range',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'default_value' => '',
                        'min' => '',
                        'max' => '',
                        'step' => '',
                        'prepend' => '',
                        'append' => '',
                    ),
                    array(
                        'key' => 'field_627143765e136',
                        'label' => 'Show',
                        'name' => 'show',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'latest' => 'Latest',
                            'specific' => 'Specific',
                        ),
                        'default_value' => false,
                        'allow_null' => 1,
                        'multiple' => 0,
                        'ui' => 0,
                        'return_format' => 'value',
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_627144a2b20fa',
                        'label' => 'Select Category Type',
                        'name' => 'select_category_type',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_627143765e136',
                                    'operator' => '==',
                                    'value' => 'latest',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'include' => 'Include Category',
                            'exclude' => 'Exclude Category',
                        ),
                        'default_value' => 'include',
                        'allow_null' => 0,
                        'multiple' => 0,
                        'ui' => 0,
                        'return_format' => 'value',
                        'ajax' => 0,
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'field_627144d788289',
                        'label' => 'Category Include',
                        'name' => 'category_include',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_627144a2b20fa',
                                    'operator' => '==',
                                    'value' => 'include',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'review_type',
                        'field_type' => 'multi_select',
                        'allow_null' => 0,
                        'add_term' => 1,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'object',
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_627145275d0b2',
                        'label' => 'Category Exclude',
                        'name' => 'category_exclude',
                        'type' => 'taxonomy',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_627144a2b20fa',
                                    'operator' => '==',
                                    'value' => 'exclude',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'taxonomy' => 'review_type',
                        'field_type' => 'multi_select',
                        'allow_null' => 0,
                        'add_term' => 1,
                        'save_terms' => 0,
                        'load_terms' => 0,
                        'return_format' => 'object',
                        'multiple' => 0,
                    ),
                    array(
                        'key' => 'field_6271455ef23bb',
                        'label' => 'Posts',
                        'name' => 'elements_post',
                        'type' => 'relationship',
                        'instructions' => '',
                        'required' => 1,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_627143765e136',
                                    'operator' => '==',
                                    'value' => 'specific',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'post_type' => array(
                            0 => 'reviews',
                        ),
                        'taxonomy' => '',
                        'filters' => array(
                            0 => 'search',
                            1 => 'post_type',
                            2 => 'taxonomy',
                        ),
                        'elements' => array(
                            0 => 'featured_image',
                        ),
                        'min' => '',
                        'max' => '',
                        'return_format' => 'id',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/directory',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }
}

$directory_class = new Wpcr_Sportsbooks_Reviews_Block_Directory();
$directory_class->init();

add_action('wp_ajax_block_directory_list', 'block_directory_list');
add_action('wp_ajax_nopriv_block_directory_list', 'block_directory_list');
add_action('wp_enqueue_scripts', 'block_directory_scripts');

function block_directory_scripts() {
    wp_enqueue_script('jquery');

    $directory_class = new Wpcr_Sportsbooks_Reviews_Block_Directory();
    $block_name = $directory_class->get_block_name();

    $template_dir = get_template_directory();
    $template_uri = get_template_directory_uri();
    $plugin_dir = basename(plugin_dir_path(dirname(__FILE__ , 2)));
    
    $custom_css_base = $plugin_dir.'-templates/block-'.$block_name.'.css';

    if (file_exists($template_dir.'/'.$custom_css_base)) {
        wp_enqueue_style('block-'.$block_name.'-style', $template_uri.'/'.$custom_css_base, [], true);
    }
}

function block_directory_list()
{
    $title = (isset($_POST['title']) && !empty($_POST['title'])) ? sanitize_text_field($_POST['title']) : '';
    $current_page = (isset($_POST['page'])) ? sanitize_text_field($_POST['page']) : 1 ;
    $label_link = (isset($_POST['label_link']) && !empty($_POST['label_link'])) 
        ? sanitize_text_field($_POST['label_link']) 
        : __('Read Review');
    $per_page = (isset($_POST['per_page']) && 
                !empty($_POST['per_page']) && 
                intval($_POST['per_page']) > 0) ? intval(sanitize_text_field($_POST['per_page'])) : 10;

    $show = (isset($_POST['show']) && !empty($_POST['show'])) ? sanitize_text_field($_POST['show']) : '';
    $posts = (isset($_POST['elements_post']) && 
                !empty($_POST['elements_post'])) ? unserialize(sanitize_text_field($_POST['elements_post'])) : [];
    $select_category_type = (isset($_POST['select_category_type']) && 
            !empty($_POST['select_category_type'])) ? sanitize_text_field($_POST['select_category_type']) : [];
    $category_include = (isset($_POST['category_include']) && 
            !empty($_POST['category_include'])) ? unserialize(sanitize_text_field($_POST['category_include'])) : [];
    $category_exclude = (isset($_POST['category_exclude']) && 
            !empty($_POST['category_exclude'])) ? unserialize(sanitize_text_field($_POST['category_exclude'])) : [];

    $attributes = [
        'show' => $show,
        'posts' => $posts,
        'quantity' => $per_page,
        'select_category_type' => $select_category_type,
        'category_include' => $category_include,
        'category_exclude' => $category_exclude,
    ];

    $current_letter = '';
    if (isset($_POST['letter']) && !empty($_POST['letter'])) {
        $current_letter = sanitize_text_field($_POST['letter']);
    }

    $letters = str_split('#0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ');
    $current_letter = in_array($current_letter, $letters) ? $current_letter : false;

    // Get items and information
    $review_entity = new WpcrReviewEntity($per_page, $current_page, $attributes);
    $reviews = $review_entity->get_paged_reviews($current_letter);

    $reviews_paginator = $review_entity->get_paginator();
    $reviews_letters_bar = $review_entity->get_letter_items_for_bar();

    require_once 'partials/wpcr-reviews-list.php';

    $no_of_paginations = ceil($reviews_paginator['total'] / $per_page);

    require_once 'partials/wpcr-review-paginator.php';

    exit();
}

function block_directory_get_per_page($fields) {
    if (intval($fields['quantity']) > 0) {
        return intval($fields['quantity']);
    }

    return 10;
}