<?php
require_once WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . "includes/class-wpcr-sportsbooks-reviews-utils.php";

class Wpcr_Sportsbooks_Reviews_Block_Pro_Con extends \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils {

    private $blockName          = 'pro-con';
    private $blockFolderName    = 'pro-con';
    private $blockTitle         = 'Pros and Cons';
    private $blockDescription   = '';
    private $blockIcon          = 'admin-links';
    private $blockKeywords      = ['pro', 'con'];
    private $category           = "reviews-blocks";
    private $utils;

    function init() {
        $this->utils = new \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils();
        $this->register_block();
        $this->register_fields();
    }

    function get_block_name() {
        return $this->blockName;
    }

    function register_block()
    {
        if (function_exists('acf_register_block')) {
            acf_register_block(
                array(
                    'name' => $this->blockName,
                    'title' => __($this->blockTitle),
                    'description' => __($this->blockDescription),
                    'render_template' => WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . 'blocks/'. $this->blockFolderName .'/template.php',
                    'category' => $this->category,
                    'icon' => $this->blockIcon,
                    'keywords' => $this->blockKeywords,
                    'enqueue_style' => $this->utils->wpcr_sportsbooks_reviews_webpack('block_pro_con.css'),
                )
            );
        }
    }

    function register_fields() {
        if(function_exists('acf_add_local_field_group')):
            acf_add_local_field_group(array(
                'key' => 'group_block_pros_cons',
                'title' => 'Block_Pro_Cons',
                'fields' => array(
                    array(
                        'key' => 'field_block_pros_cons_001',
                        'label' => 'Title',
                        'name' => 'title',
                        'type' => 'text',
                        'required' => 0,
                    ),
                    array(
                        'key' => 'field_block_pros_cons_002',
                        'label' => 'Maximum width',
                        'name' => 'width',
                        'type' => 'range',
                        'required' => 1,
                        'default_value' => 100,
                        'min' => 5,
                        'max' => 100,
                        'step' => 5,
                    ),
                    array(
                        'key' => 'field_block_pros_cons_003',
                        'label' => 'Sections',
                        'name' => 'sections',
                        'type' => 'repeater',
                        'min' => 1,
                        'max' => 4,
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_block_pros_cons_004',
                                'label' => 'Title',
                                'name' => 'title',
                                'type' => 'text',
                                'required' => 0,
                            ),
                            array(
                                'key' => 'field_block_pros_cons_005',
                                'label' => 'List Style',
                                'name' => 'list_style',
                                'type' => 'select',
                                'required' => 1,
                                'choices' => array(
                                    'fas fa-check-circle' => 'Check circle',
                                    'fas fa-times-circle' => 'Times circle',
                                    'fas fa-plus-circle' => 'Plus circle',
                                    'fas fa-minus-circle' => 'Minus circle',
                                    'fas fa-chevron-circle-right' => 'Chevron circle',
                                    'fas fa-arrow-alt-circle-right' => 'Arrow circle',
                                    'fas fa-circle' => 'Circle',
                                    'fas fa-dot-circle' => 'Dot circle',
                                ),
                                'default_value' => 'fas fa-check-circle',
                                'return_format' => 'value',
                            ),
                            array(
                                'key' => 'field_block_pros_cons_006',
                                'label' => 'Color',
                                'name' => 'color',
                                'type' => 'select',
                                'required' => 1,
                                'choices' => array(
                                    '#7ec151' => 'Green',
                                    '#f03434' => 'Red',
                                    'other' => 'Other',
                                ),
                                'default_value' => '#7ec151',
                                'return_format' => 'value',
                            ),
                            array(
                                'key' => 'field_block_pros_cons_007',
                                'label' => 'Color picker',
                                'name' => 'color_picker',
                                'type' => 'color_picker',
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_block_pros_cons_006',
                                            'operator' => '==',
                                            'value' => 'other',
                                        ),
                                    ),
                                ),
                            ),
                            array(
                                'key' => 'field_block_pros_cons_008',
                                'label' => 'Content',
                                'name' => 'content',
                                'type' => 'wysiwyg',
                                'instructions' => '',
                                'required' => 1,
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'media_upload' => 0,
                                'delay' => 0,
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/pro-con',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }
}

$directory_class = new Wpcr_Sportsbooks_Reviews_Block_Pro_Con();
$directory_class->init();

add_action('wp_enqueue_scripts', 'block_pro_con_scripts');

function block_pro_con_scripts() {
    $pro_con_class = new Wpcr_Sportsbooks_Reviews_Block_Pro_Con();
    $block_name = $pro_con_class->get_block_name();

    $template_dir = get_template_directory();
    $template_uri = get_template_directory_uri();
    $plugin_dir = basename(plugin_dir_path(dirname(__FILE__ , 2)));
    
    $custom_css_base = $plugin_dir.'-templates/block-'.$block_name.'.css';

    if (file_exists($template_dir.'/'.$custom_css_base)) {
        wp_enqueue_style('block-'.$block_name.'-style', $template_uri.'/'.$custom_css_base, [], true);
    }
}