<?php
require_once WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . "includes/class-wpcr-sportsbooks-reviews-utils.php";

class Wpcr_Sportsbooks_Reviews_Block_Review_Header extends \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils
{
    private $blockName          = 'review-header';
    private $blockFolderName    = 'review-header';
    private $blockTitle         = 'Review Header';
    private $blockDescription   = '';
    private $blockIcon          = 'admin-links';
    private $blockKeywords      = ['review', 'header'];
    private $category           = "reviews-blocks";
    private $utils;

    function init() {
        $this->utils = new \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils();
        $this->register_block();
        $this->register_fields();
    }

    function get_block_name() {
        return $this->blockName;
    }

    function register_block() {
        if (function_exists('acf_register_block')) {
            acf_register_block(
                array(
                    'name' => $this->blockName,
                    'title' => __($this->blockTitle),
                    'description' => __($this->blockDescription),
                    'render_template' => WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . 'blocks/'. $this->blockFolderName .'/template.php',
                    'category' => $this->category,
                    'icon' => $this->blockIcon,
                    'keywords' => $this->blockKeywords,
                    'enqueue_style' => $this->utils->wpcr_sportsbooks_reviews_webpack('block_review_header.css'),
                )
            );
        }
    }

    function register_fields() {
        if( function_exists('acf_add_local_field_group') ):
            acf_add_local_field_group(array(
                'key' => 'group_block_review_header',
                'title' => 'Block_Review_Header',
                'fields' => array(
                    array(
                        'key' => 'field_block_review_header_title',
                        'label' => __('Title'),
                        'name' => 'title',
                        'type' => 'text',
                        'required' => 0,
                    ),
                    array(
                        'key' => 'field_block_review_header_logo',
                        'label' => __('Logo'),
                        'name' => 'logo',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 1,
                        'return_format' => 'array',
                        'preview_size' => 'medium',
                        'library' => 'all',
                    ),
                    array(
                        'key' => 'field_block_review_header_rating',
                        'label' => __('Rating'),
                        'type' => 'select',
                        'name' => 'rating',
                        'required' => 1,
                        'choices' => [
                            1 => '1',
                            2 => '1.5',
                            3 => '2',
                            4 => '2.5',
                            5 => '3',
                            6 => '3.5',
                            7 => '4',
                            8 => '4.5',
                            9 => '5',
                        ],
                        'allow_null' => 1,
                    ),
                    array(
                        'key' => 'field_block_review_header_bonus',
                        'label' => __('Bonus Column'),
                        'name' => 'bonus',
                        'type' => 'group',
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_block_review_header_bonus_title',
                                'label' => __('Bonus Title'),
                                'name' => 'bonus_title',
                                'type' => 'text',
                                'required' => 0,
                            ),
                            array(
                                'key' => 'field_block_review_header_bonus_description',
                                'label' => __('Description'),
                                'name' => 'bonus',
                                'type' => 'wysiwyg',
                                'required' => 1,
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'delay' => 0,
                            ),
                            array(
                                'key' => 'field_block_review_header_bonus_link',
                                'label' => __('Link'),
                                'name' => 'link',
                                'type' => 'link',
                                'required' => 1,
                                'return_format' => 'array',
                            ),
                            array(
                                'key' => 'field_block_review_header_bonus_attributes',
                                'label' => 'Attributes',
                                'name' => 'attributes',
                                'type' => 'checkbox',
                                'choices' => array(
                                    'noreferrer' => __('No Referrer'),
                                    'noopener' => __('No Opener'),
                                    'nofollow' => __('No Follow'),
                                ),
                                'layout' => 'vertical',
                                'toggle' => 0,
                                'return_format' => 'value',
                                'save_custom' => 0,
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_block_review_header_product',
                        'label' => __('Product Column'),
                        'name' => 'product',
                        'type' => 'group',
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_block_review_header_products_title',
                                'label' => __('Products Title'),
                                'name' => 'products_title',
                                'type' => 'text',
                                'required' => 0,
                            ),
                            array(
                                'key' => 'field_block_review_header_product_list_style',
                                'label' => 'List Style',
                                'name' => 'list_style',
                                'type' => 'select',
                                'required' => 1,
                                'choices' => array(
                                    'fas fa-check-circle' => 'Check circle',
                                    'fas fa-times-circle' => 'Times circle',
                                    'fas fa-plus-circle' => 'Plus circle',
                                    'fas fa-minus-circle' => 'Minus circle',
                                    'fas fa-chevron-circle-right' => 'Chevron circle',
                                    'fas fa-arrow-alt-circle-right' => 'Arrow circle',
                                    'fas fa-circle' => 'Circle',
                                    'fas fa-dot-circle' => 'Dot circle',
                                ),
                                'default_value' => 'fas fa-check-circle',
                                'return_format' => 'value',
                            ),
                            array(
                                'key' => 'field_block_review_header_product_list_color',
                                'label' => 'List Color',
                                'name' => 'list_color',
                                'type' => 'select',
                                'required' => 1,
                                'choices' => array(
                                    '#7ec151' => 'Green',
                                    '#f03434' => 'Red',
                                    'other' => 'Other',
                                ),
                                'default_value' => '#7ec151',
                                'return_format' => 'value',
                            ),
                            array(
                                'key' => 'field_block_review_header_product_color_picker',
                                'label' => 'Color picker',
                                'name' => 'color_picker',
                                'type' => 'color_picker',
                                'conditional_logic' => array(
                                    array(
                                        array(
                                            'field' => 'field_block_review_header_product_list_color',
                                            'operator' => '==',
                                            'value' => 'other',
                                        ),
                                    ),
                                ),
                            ),
                            array(
                                'key' => 'field_block_review_header_product_list',
                                'label' => __('List of products'),
                                'name' => 'list_product',
                                'type' => 'wysiwyg',
                                'required' => 1,
                                'tabs' => 'all',
                                'toolbar' => 'full',
                                'delay' => 0,
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_block_review_header_deposit_title',
                        'label' => __('Deposit Methods Title'),
                        'name' => 'deposit_title',
                        'type' => 'text',
                        'required' => 0,
                    ),
                    array(
                        'key' => 'field_block_review_header_deposit',
                        'label' => __('Deposit Methods'),
                        'name' => 'deposit_methods',
                        'type' => 'repeater',
                        'required' => 1,
                        'min' => 1,
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_block_review_header_deposit_method',
                                'label' => __('Method'),
                                'name' => 'method',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 1,
                                'return_format' => 'array',
                                'preview_size' => 'medium',
                                'library' => 'all',
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_block_review_header_payout_title',
                        'label' => __('Payout Methods Title'),
                        'name' => 'payout_title',
                        'type' => 'text',
                        'required' => 0,
                    ),
                    array(
                        'key' => 'field_block_review_header_payout',
                        'label' => __('Payout Methods'),
                        'name' => 'payout_methods',
                        'type' => 'repeater',
                        'required' => 1,
                        'min' => 1,
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_block_review_header_payout_method',
                                'label' => __('Method'),
                                'name' => 'method',
                                'type' => 'image',
                                'instructions' => '',
                                'required' => 1,
                                'return_format' => 'array',
                                'preview_size' => 'medium',
                                'library' => 'all',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/review-header',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }
}

$review_header_class = new Wpcr_Sportsbooks_Reviews_Block_Review_Header();
$review_header_class->init();

add_action('wp_enqueue_scripts', 'block_review_header_scripts');

function block_review_header_scripts() {
    $review_header_class = new Wpcr_Sportsbooks_Reviews_Block_Review_Header();
    $block_name = $review_header_class->get_block_name();

    $template_dir = get_template_directory();
    $template_uri = get_template_directory_uri();
    $plugin_dir = basename(plugin_dir_path(dirname(__FILE__ , 2)));
    
    $custom_css_base = $plugin_dir.'-templates/block-'.$block_name.'.css';

    if (file_exists($template_dir.'/'.$custom_css_base)) {
        wp_enqueue_style('block-'.$block_name.'-style', $template_uri.'/'.$custom_css_base, [], true);
    }
}
