<?php
require_once WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . "includes/class-wpcr-sportsbooks-reviews-utils.php";

class Wpcr_Sportsbooks_Reviews_Block_Table_Content extends \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils {

    private $blockName          = 'table-content';
    private $blockFolderName    = 'table-content';
    private $blockTitle         = 'Table Content';
    private $blockDescription   = '';
    private $blockIcon          = 'admin-links';
    private $blockKeywords      = ['custom', 'table', 'content'];
    private $category           = "reviews-blocks";
    private $utils;

    function init() {
        $this->utils = new \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils();
        $this->register_block();
        $this->register_fields();
    }

    function get_block_name() {
        return $this->blockName;
    }

    function register_block()
    {
        if (function_exists('acf_register_block')) {
            acf_register_block(
                array(
                    'name' => $this->blockName,
                    'title' => __($this->blockTitle),
                    'description' => __($this->blockDescription),
                    'render_template' => WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . 'blocks/'. $this->blockFolderName .'/template.php',
                    'category' => $this->category,
                    'icon' => $this->blockIcon,
                    'keywords' => $this->blockKeywords,
                    'enqueue_style' => $this->utils->wpcr_sportsbooks_reviews_webpack('block_table_content.css'),
                )
            );
        }
    }

    function register_fields() {
        if(function_exists('acf_add_local_field_group')):
            acf_add_local_field_group(array(
                'key' => 'group_block_table_content',
                'title' => 'Block_Table_Content',
                'fields' => array(
                    array(
                        'key' => 'field_block_table_content_title',
                        'label' => __('Title'),
                        'name' => 'title',
                        'type' => 'text',
                        'required' => 0,
                    ),
                    array(
                        'key' => 'field_block_table_content_list_style',
                        'label' => __('List Style'),
                        'name' => 'list_style',
                        'type' => 'select',
                        'required' => 1,
                        'choices' => array(
                            'fas fa-check-circle' => 'Check circle',
                            'fas fa-times-circle' => 'Times circle',
                            'fas fa-plus-circle' => 'Plus circle',
                            'fas fa-minus-circle' => 'Minus circle',
                            'fas fa-chevron-circle-right' => 'Chevron circle',
                            'fas fa-arrow-alt-circle-right' => 'Arrow circle',
                            'fas fa-circle' => 'Circle',
                            'fas fa-dot-circle' => 'Dot circle',
                        ),
                        'default_value' => 'fas fa-check-circle',
                        'return_format' => 'value',
                    ),
                    array(
                        'key' => 'field_block_table_content_size',
                        'label' => __('List Style Size'),
                        'name' => 'size',
                        'type' => 'select',
                        'required' => 1,
                        'choices' => array(
                            'big' => 'Big',
                            'medium' => 'Medium',
                            'small' => 'Small',
                        ),
                        'default_value' => 'big',
                        'return_format' => 'value',
                    ),
                    array(
                        'key' => 'field_block_table_content_color',
                        'label' => __('Color'),
                        'name' => 'color',
                        'type' => 'select',
                        'required' => 1,
                        'choices' => array(
                            '#7ec151' => 'Green',
                            '#f03434' => 'Red',
                            'other' => 'Other',
                        ),
                        'default_value' => '#7ec151',
                        'return_format' => 'value',
                    ),
                    array(
                        'key' => 'field_block_table_content_color_picker',
                        'label' => __('Color picker'),
                        'name' => 'color_picker',
                        'type' => 'color_picker',
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'field_block_table_content_color',
                                    'operator' => '==',
                                    'value' => 'other',
                                ),
                            ),
                        ),
                    ),
                    array(
                        'key' => 'field_block_table_content_content',
                        'label' => __('Content'),
                        'name' => 'contents',
                        'type' => 'repeater',
                        'min' => 1,
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_block_table_content_link',
                                'label' => __('Link'),
                                'name' => 'link',
                                'type' => 'link',
                                'required' => 1,
                                'return_format' => 'array',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/table-content',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }
}

$directory_class = new Wpcr_Sportsbooks_Reviews_Block_Table_Content();
$directory_class->init();

add_action('wp_enqueue_scripts', 'block_table_content_scripts');

function block_table_content_scripts() {
    $table_content_class = new Wpcr_Sportsbooks_Reviews_Block_Table_Content();
    $block_name = $table_content_class->get_block_name();

    $template_dir = get_template_directory();
    $template_uri = get_template_directory_uri();
    $plugin_dir = basename(plugin_dir_path(dirname(__FILE__ , 2)));
    
    $custom_css_base = $plugin_dir.'-templates/block-'.$block_name.'.css';

    if (file_exists($template_dir.'/'.$custom_css_base)) {
        wp_enqueue_style('block-'.$block_name.'-style', $template_uri.'/'.$custom_css_base, [], true);
    }
}