<?php

class Wpcr_Sportsbooks_Blocks {
    public function Wpcr_Sportsbooks_Blocks_Spaces_Fields () {
        if (function_exists('acf_add_local_field_group')) {
            acf_add_local_field_group(array(
                'key' => 'wpcr_sportsbooks_blocks_group_spaces',
                'title' => 'Top Spaces',
                'fields' => $this->Wpcr_Sportsbooks_Blocks_Spaces_get_fields(false),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/custom-sidebar',
                        ),
                    ),
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/directory',
                        ),
                    ),
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/faq',
                        ),
                    ),
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/logo-rating',
                        ),
                    ),
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/message-image',
                        ),
                    ),
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/overall-rating',
                        ),
                    ),
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/paragraph-image',
                        ),
                    ),
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/pro-con',
                        ),
                    ),
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/table-content',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

            acf_add_local_field_group(array(
                'key' => 'wpcr_sportsbooks_blocks_group_spaces_header',
                'title' => 'Top Spaces',
                'fields' => $this->Wpcr_Sportsbooks_Blocks_Spaces_get_fields(true),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/review-header',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));
        }
    }

    public function Wpcr_Sportsbooks_Template_Review_Breadcrumbs () {
        if (function_exists('acf_add_local_field_group')) {
            acf_add_local_field_group(array(
                'key' => 'wpcr_sportsbooks_review_breadcrumbs',
                'title' => 'Breadcrumbs',
                'fields' => array(
                    array(
                        'key' => 'field_6261a22646048',
                        'label' => 'Items',
                        'name' => 'breadcrumbs',
                        'type' => 'repeater',
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_6261a23746049',
                                'label' => 'Link',
                                'name' => 'link',
                                'type' => 'link',
                                'required' => 1,
                                'return_format' => 'array',
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'post_type',
                            'operator' => '==',
                            'value' => 'reviews',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'side',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));
        }
    }

	public function Wpcr_Sportsbooks_Blocks_Spaces_classes ($fields) {
		$classes = [];

		if (!empty($fields['top_space'])) {
            if (strpos($fields['top_space'], '-negative') !== false) {
                $classes[] = 'negative-top';
            }

			$classes[] = $fields['top_space'];
		}

		if (!empty($fields['right_space'])) {
			$classes[] = $fields['right_space'];
		}

		if (!empty($fields['bottom_space'])) {
			$classes[] = $fields['bottom_space'];
		}

		if (!empty($fields['left_space'])) {
			$classes[] = $fields['left_space'];
		}

		if (count($classes) > 0) {
			return implode(' ', $classes);
		}

		return '';
	}

    public function Wpcr_Sportsbooks_Blocks_Spaces_get_fields ($header = false) {
        $fields[] = [
            'key' => 'wpcr_sportsbooks_blocks_field_001',
            'label' => 'Block Spaces',
            'name' => 'wpcr_sportsbooks_accordion',
            'type' => 'accordion',
        ];

        $margin_top_elements_negatives = [
            'mt-1-negative' => 'Margin Top -1',
            'mt-2-negative' => 'Margin Top -2',
            'mt-3-negative' => 'Margin Top -3',
            'mt-4-negative' => 'Margin Top -4',
            'mt-5-negative' => 'Margin Top -5',
            'mt-6-negative' => 'Margin Top -6',
            'mt-7-negative' => 'Margin Top -7',
            'mt-8-negative' => 'Margin Top -8',
            'mt-9-negative' => 'Margin Top -9',
            'mt-10-negative' => 'Margin Top -10',
        ];

        $margin_top_elements_positives = [
            'mt-0' => 'Margin Top 0',
            'mt-1' => 'Margin Top 1',
            'mt-2' => 'Margin Top 2',
            'mt-3' => 'Margin Top 3',
            'mt-4' => 'Margin Top 4',
            'mt-5' => 'Margin Top 5',
            'mt-6' => 'Margin Top 6',
            'mt-7' => 'Margin Top 7',
            'mt-8' => 'Margin Top 8',
            'mt-9' => 'Margin Top 9',
            'mt-10' => 'Margin Top 10',
            'pt-0' => 'Padding Top 0',
            'pt-1' => 'Padding Top 1',
            'pt-2' => 'Padding Top 2',
            'pt-3' => 'Padding Top 3',
            'pt-4' => 'Padding Top 4',
            'pt-5' => 'Padding Top 5',
            'pt-6' => 'Padding Top 6',
            'pt-7' => 'Padding Top 7',
            'pt-8' => 'Padding Top 8',
            'pt-9' => 'Padding Top 9',
            'pt-10' => 'Padding Top 10',
        ];

        if ($header === true) {
            $mt_elements = array_merge($margin_top_elements_negatives, $margin_top_elements_positives);
        } else {
            $mt_elements = $margin_top_elements_positives;
        }

        $fields[] = [
            'key' => ($header === true) ? 'wpcr_sportsbooks_blocks_field_002' : 'wpcr_sportsbooks_blocks_field_0022',
            'label' => 'Top',
            'name' => 'top_space',
            'type' => 'select',
            'choices' => $mt_elements,
            'default_value' => 'mt-0',
            'return_format' => 'value',
            'ajax' => 0,
        ];

        $fields[] = [
            'key' => 'wpcr_sportsbooks_blocks_field_003',
            'label' => 'Right',
            'name' => 'right_space',
            'type' => 'select',
            'choices' => array(
                'mr-0' => 'Margin Right 0',
                'mr-1' => 'Margin Right 1',
                'mr-2' => 'Margin Right 2',
                'mr-3' => 'Margin Right 3',
                'mr-4' => 'Margin Right 4',
                'mr-5' => 'Margin Right 5',
                'mr-6' => 'Margin Right 6',
                'mr-7' => 'Margin Right 7',
                'mr-8' => 'Margin Right 8',
                'mr-9' => 'Margin Right 9',
                'mr-10' => 'Margin Right 10',
                'pr-0' => 'Padding Right 0',
                'pr-1' => 'Padding Right 1',
                'pr-2' => 'Padding Right 2',
                'pr-3' => 'Padding Right 3',
                'pr-4' => 'Padding Right 4',
                'pr-5' => 'Padding Right 5',
                'pr-6' => 'Padding Right 6',
                'pr-7' => 'Padding Right 7',
                'pr-8' => 'Padding Right 8',
                'pr-9' => 'Padding Right 9',
                'pr-10' => 'Padding Right 10',
            ),
            'default_value' => 'mr-0',
            'return_format' => 'value',
            'ajax' => 0,
        ];

        $fields[] = [
            'key' => 'wpcr_sportsbooks_blocks_field_004',
            'label' => 'Bottom',
            'name' => 'bottom_space',
            'type' => 'select',
            'choices' => array(
                'mb-0' => 'Margin Bottom 0',
                'mb-1' => 'Margin Bottom 1',
                'mb-2' => 'Margin Bottom 2',
                'mb-3' => 'Margin Bottom 3',
                'mb-4' => 'Margin Bottom 4',
                'mb-5' => 'Margin Bottom 5',
                'mb-6' => 'Margin Bottom 6',
                'mb-7' => 'Margin Bottom 7',
                'mb-8' => 'Margin Bottom 8',
                'mb-9' => 'Margin Bottom 9',
                'mb-10' => 'Margin Bottom 10',
                'pb-0' => 'Padding Bottom 0',
                'pb-1' => 'Padding Bottom 1',
                'pb-2' => 'Padding Bottom 2',
                'pb-3' => 'Padding Bottom 3',
                'pb-4' => 'Padding Bottom 4',
                'pb-5' => 'Padding Bottom 5',
                'pb-6' => 'Padding Bottom 6',
                'pb-7' => 'Padding Bottom 7',
                'pb-8' => 'Padding Bottom 8',
                'pb-9' => 'Padding Bottom 9',
                'pb-10' => 'Padding Bottom 10',
            ),
            'default_value' => 'mb-0',
            'return_format' => 'value',
            'ajax' => 0,
        ];

        $fields[] = [
            'key' => 'wpcr_sportsbooks_blocks_field_005',
            'label' => 'Left',
            'name' => 'left_space',
            'type' => 'select',
            'choices' => array(
                'ml-0' => 'Margin Left 0',
                'ml-1' => 'Margin Left 1',
                'ml-2' => 'Margin Left 2',
                'ml-3' => 'Margin Left 3',
                'ml-4' => 'Margin Left 4',
                'ml-5' => 'Margin Left 5',
                'ml-6' => 'Margin Left 6',
                'ml-7' => 'Margin Left 7',
                'ml-8' => 'Margin Left 8',
                'ml-9' => 'Margin Left 9',
                'ml-10' => 'Margin Left 10',
                'pl-0' => 'Padding Left 0',
                'pl-1' => 'Padding Left 1',
                'pl-2' => 'Padding Left 2',
                'pl-3' => 'Padding Left 3',
                'pl-4' => 'Padding Left 4',
                'pl-5' => 'Padding Left 5',
                'pl-6' => 'Padding Left 6',
                'pl-7' => 'Padding Left 7',
                'pl-8' => 'Padding Left 8',
                'pl-9' => 'Padding Left 9',
                'pl-10' => 'Padding Left 10',
            ),
            'default_value' => 'ml-0',
            'return_format' => 'value',
            'ajax' => 0,
        ];

        return $fields;
    }
}
