<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       https://www.wpcostarica.com
 * @since      1.0.0
 *
 * @package    Wpcr_Sportsbooks_Reviews
 * @subpackage Wpcr_Sportsbooks_Reviews/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Wpcr_Sportsbooks_Reviews
 * @subpackage Wpcr_Sportsbooks_Reviews/includes
 * @author     WPCR <mario@wpcostarica.com>
 */
class Wpcr_Sportsbooks_Reviews {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Wpcr_Sportsbooks_Reviews_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if (defined('WPCR_SPORTSBOOKS_REVIEWS_VERSION')) {
			$this->version = WPCR_SPORTSBOOKS_REVIEWS_VERSION;
		} else {
			$this->version = '1.0.0';
		}

		$this->plugin_name = 'wpcr-sportsbooks-reviews';

		$this->load_dependencies();
        $this->set_locale();
		$this->define_admin_hooks();
        $this->setup_core();
	}

    /**
     * Setup the core elements to support the functionalities
     *
     * @since    0.0.1
     * @access   private
     */
    private function setup_core() {
        $plugin_core = new Wpcr_Sportsbooks_Reviews_Core($this->get_plugin_name(), $this->get_version());

        $this->loader->add_action('init', $plugin_core, 'init');
    }

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Wpcr_Sportsbooks_Reviews_Loader. Orchestrates the hooks of the plugin.
	 * - Wpcr_Sportsbooks_Reviews_i18n. Defines internationalization functionality.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		if(!class_exists('ACF')) {
			//BEGIN Load ACF
			// Define path and URL to the ACF plugin.
			define( 'MY_ACF_PATH', plugin_dir_path(__DIR__) . 'includes/acf/acf-pro/' );
			define( 'MY_ACF_URL', plugin_dir_url(__DIR__) . 'includes/acf/acf-pro/' );

			// Include the ACF plugin.
			include_once( MY_ACF_PATH . 'acf.php' );

			// Customize the url setting to fix incorrect asset URLs.
			add_filter('acf/settings/url', 'my_acf_settings_url');
			function my_acf_settings_url( $url ) {
				return MY_ACF_URL;
			}
		}
        

        // (Optional) Hide the ACF admin menu item.
        //add_filter('acf/settings/show_admin', 'my_acf_settings_show_admin');
        //function my_acf_settings_show_admin( $show_admin ) {
        //    return false;
        //}

        //END Load ACF

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-wpcr-sportsbooks-reviews-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-wpcr-sportsbooks-reviews-i18n.php';

        /**
         * The class responsible for defining core elements required to support the
         * functionality
         */
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-wpcr-sportsbooks-reviews-core.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-wpcr-sportsbooks-reviews-admin.php';

		$this->loader = new Wpcr_Sportsbooks_Reviews_Loader();
	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Wpcr_Sportsbooks_Reviews_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {
		$plugin_i18n = new Wpcr_Sportsbooks_Reviews_i18n();

		$this->loader->add_action('plugins_loaded', $plugin_i18n, 'load_plugin_textdomain');
	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {
		$plugin_admin = new Wpcr_Sportsbooks_Reviews_Admin( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Wpcr_Sportsbooks_Reviews_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}
}
