<?php
require_once WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . "includes/class-wpcr-sportsbooks-reviews-utils.php";

class Wpcr_Sportsbooks_Reviews_Block_Overall_Rating extends \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils
{
    private $blockName          = 'overall-rating';
    private $blockFolderName    = 'overall-rating';
    private $blockTitle         = 'Overall Rating';
    private $blockDescription   = '';
    private $blockIcon          = 'admin-links';
    private $blockKeywords      = ['review', 'overall', 'rating'];
    private $category           = "reviews-blocks";
    private $utils;

    function init() {
        $this->utils = new \WpcrSportsbooksReviewsUtils\Wpcr_Sportsbooks_Reviews_Utils();
        $this->register_block();
        $this->register_fields();
    }

    function get_block_name() {
        return $this->blockName;
    }

    function register_block() {
        if (function_exists('acf_register_block')) {
            acf_register_block(
                array(
                    'name' => $this->blockName,
                    'title' => __($this->blockTitle),
                    'description' => __($this->blockDescription),
                    'render_template' => WPCR_SPORTSBOOKS_REVIEWS_DIRECTORY . 'blocks/'. $this->blockFolderName .'/template.php',
                    'category' => $this->category,
                    'icon' => $this->blockIcon,
                    'keywords' => $this->blockKeywords,
                    'enqueue_style' => $this->utils->wpcr_sportsbooks_reviews_webpack('block_overall_rating.css'),
                )
            );
        }
    }

    function register_fields() {
        if(function_exists('acf_add_local_field_group')):
            acf_add_local_field_group(array(
                'key' => 'group_block_overall_rating',
                'title' => 'Block_Overall_Rating',
                'fields' => array(
                    array(
                        'key' => 'field_block_overall_rating_title',
                        'label' => __('Title'),
                        'name' => 'title',
                        'type' => 'text',
                        'required' => 0,
                    ),
                    array(
                        'key' => 'field_block_overall_rating_title_overall',
                        'label' => __('Overall Rating Title'),
                        'name' => 'overall_title',
                        'type' => 'text',
                        'required' => 0,
                    ),
                    array(
                        'key' => 'field_block_overall_rating_items',
                        'label' => __('Items'),
                        'name' => 'items',
                        'type' => 'repeater',
                        'required' => 1,
                        'min' => 1,
                        'layout' => 'block',
                        'sub_fields' => array(
                            array(
                                'key' => 'field_block_overall_rating_title',
                                'label' => __('Title'),
                                'name' => 'title',
                                'type' => 'text',
                                'required' => 0,
                            ),
                            array(
                                'key' => 'field_block_overall_rating_rating',
                                'label' => __('Rating'),
                                'type' => 'select',
                                'name' => 'rating',
                                'required' => 1,
                                'choices' => [
                                    1 => '1',
                                    2 => '1.5',
                                    3 => '2',
                                    4 => '2.5',
                                    5 => '3',
                                    6 => '3.5',
                                    7 => '4',
                                    8 => '4.5',
                                    9 => '5',
                                ],
                                'allow_null' => 1,
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'block',
                            'operator' => '==',
                            'value' => 'acf/overall-rating',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));

        endif;
    }
}

$overall_rating_class = new Wpcr_Sportsbooks_Reviews_Block_Overall_Rating();
$overall_rating_class->init();

add_action('wp_enqueue_scripts', 'block_overall_rating_scripts');

function block_overall_rating_scripts() {
    $overall_rating_class = new Wpcr_Sportsbooks_Reviews_Block_Overall_Rating();
    $block_name = $overall_rating_class->get_block_name();

    $template_dir = get_template_directory();
    $template_uri = get_template_directory_uri();
    $plugin_dir = basename(plugin_dir_path(dirname(__FILE__ , 2)));
    
    $custom_css_base = $plugin_dir.'-templates/block-'.$block_name.'.css';

    if (file_exists($template_dir.'/'.$custom_css_base)) {
        wp_enqueue_style('block-'.$block_name.'-style', $template_uri.'/'.$custom_css_base, [], true);
    }
}
